<?php $content = app('App\Http\Controllers\FrontController'); ?>

<?php $__env->startSection('styles'); ?>
<?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
<!-- Font Awesome Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    /* Force Font Awesome icons to always display */
    .fas, .fab, .far, .fa, .fa-icon {
        display: inline-block !important;
        visibility: visible !important;
        opacity: 1 !important;
        /* Make sure icon color has good contrast with background */
        color: currentColor !important;
    }

    /* Track search animation */
    @keyframes  pulse {
        0%, 100% {
            opacity: 1;
        }
        50% {
            opacity: 0.5;
        }
    }

    .tracking-pulse {
        animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
    }

    /* Custom input focus styles */
    .tracking-input:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(255, 77, 0, 0.2);
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<section class="relative bg-secondary py-16">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute inset-0 bg-secondary bg-opacity-90"></div>
        <div class="absolute w-96 h-96 -top-20 -left-20 bg-white opacity-5 rounded-full"></div>
        <div class="absolute w-96 h-96 bottom-0 right-0 bg-primary opacity-5 rounded-full"></div>
    </div>

    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col items-center">
            <h1 class="text-3xl md:text-4xl font-bold text-white mb-4">Track Your Shipment</h1>
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="flex items-center space-x-2 text-sm text-white">
                    <li>
                        <a href="/" class="hover:text-primary transition-all">Home</a>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-chevron-right w-4 h-4 mx-1 text-white"></i>
                        <span class="text-primary">Track Order</span>
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>
        </svg>
    </div>
</section>

<!-- Tracking Form Section -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <!-- Section Title -->
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-secondary mb-4">Track Your Shipment Status</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Enter your tracking number below to get real-time updates on the location and status of your package.</p>
            </div>

            <div class="bg-white rounded-lg shadow-xl overflow-hidden" x-data="{ isLoading: false, showSuccess: false }" x-cloak>
                <!-- Tracking Form -->
                <div class="p-6 md:p-8">
                    <?php if(Session::has('error')): ?>
                    <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <i class="fas fa-exclamation-circle text-red-500"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-red-700">
                                    <strong>Error!</strong> You have entered an incorrect Tracking Number.
                                </p>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-8">
                        <div class="flex">
                            <div class="hidden md:flex flex-shrink-0 items-center justify-center w-12 h-12 rounded-full bg-blue-100 mr-4">
                                <i class="fas fa-info-circle text-blue-500 text-xl"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-semibold text-secondary mb-2">Tracking Instructions</h3>
                                <p class="text-gray-600">
                                    Enter your Cargo Tracking, Door to Door Office Order Number in the field below and click "Track Order" to get the latest status and location information for your shipment.
                                </p>
                            </div>
                        </div>
                    </div>

                    <form method="POST" action="<?php echo e(route('trackingresult')); ?>" class="tracking-id-form" @submit="isLoading = true">
                        <?php echo csrf_field(); ?>
                        <div class="flex flex-col space-y-4">
                            <div class="relative">
                                <label for="tracking-number" class="block text-gray-700 font-medium mb-2">
                                    Enter Your Tracking Number
                                </label>
                                <div class="flex">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none" style="top: 32px;">
                                        <i class="fas fa-search text-gray-400"></i>
                                    </div>
                                    <input
                                        type="text"
                                        name="trackingnumber"
                                        id="tracking-number"
                                        class="pl-10 appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 mb-2 leading-tight focus:outline-none focus:bg-white tracking-input"
                                        placeholder="e.g., REM123456789"
                                        required
                                    >
                                </div>
                                <p class="text-sm text-gray-500">Your tracking number can be found in your shipping confirmation email</p>
                            </div>

                            <div class="flex justify-center mt-4">
                                <button
                                    type="submit"
                                    class="bg-primary hover:bg-secondary text-white font-medium py-3 px-8 rounded-lg transition duration-300 flex items-center justify-center min-w-[200px]"
                                    :class="{ 'opacity-75 cursor-wait': isLoading }"
                                    :disabled="isLoading"
                                >
                                    <template x-if="!isLoading">
                                        <div class="flex items-center">
                                            <i class="fas fa-search mr-2"></i>
                                            <span>Track Order</span>
                                        </div>
                                    </template>
                                    <template x-if="isLoading">
                                        <div class="flex items-center">
                                            <i class="fas fa-spinner fa-spin mr-2"></i>
                                            <span>Searching...</span>
                                        </div>
                                    </template>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Tracking Benefits Section -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="max-w-5xl mx-auto">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-secondary mb-4">Real-Time Tracking Benefits</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Our advanced tracking system provides you with up-to-date information about your shipment's journey.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Feature 1 -->
                <div class="bg-white rounded-lg shadow p-6 text-center">
                    <div class="bg-secondary bg-opacity-10 rounded-full p-4 w-16 h-16 flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-map-marker-alt text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-secondary mb-2">Real-Time Updates</h3>
                    <p class="text-gray-600">Get instant access to the current location and status of your package throughout its journey.</p>
                </div>

                <!-- Feature 2 -->
                <div class="bg-white rounded-lg shadow p-6 text-center">
                    <div class="bg-primary bg-opacity-10 rounded-full p-4 w-16 h-16 flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-clock text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-secondary mb-2">Estimated Delivery</h3>
                    <p class="text-gray-600">Know exactly when your package will arrive with accurate estimated delivery times.</p>
                </div>

                <!-- Feature 3 -->
                <div class="bg-white rounded-lg shadow p-6 text-center">
                    <div class="bg-gray-700 bg-opacity-10 rounded-full p-4 w-16 h-16 flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-history text-gray-700 text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-secondary mb-2">Delivery History</h3>
                    <p class="text-gray-600">Access a complete history of your package's journey from origin to destination.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-secondary mb-4">Tracking FAQs</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Find answers to frequently asked questions about our shipment tracking system.</p>
            </div>

            <div class="space-y-4" x-data="{active: null}" x-cloak>
                <!-- FAQ Item 1 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <button
                        @click="active = active === 1 ? null : 1"
                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"
                    >
                        <span>What information do I need to track my shipment?</span>
                        <i class="fas" :class="active === 1 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                    </button>

                    <div x-show="active === 1" x-cloak class="p-4 bg-white">
                        <p class="text-gray-600">
                            You only need your unique tracking number, which can be found in your shipping confirmation email or receipt. Enter this number in the tracking field to get real-time updates on your shipment's status and location.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 2 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <button
                        @click="active = active === 2 ? null : 2"
                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"
                    >
                        <span>How often is my tracking information updated?</span>
                        <i class="fas" :class="active === 2 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                    </button>

                    <div x-show="active === 2" x-cloak class="p-4 bg-white">
                        <p class="text-gray-600">
                            Your tracking information is updated in real-time as your shipment moves through our network. Updates typically occur when your package arrives at or departs from a facility, or when there's a change in your shipment's status.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 3 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <button
                        @click="active = active === 3 ? null : 3"
                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"
                    >
                        <span>What if my tracking number isn't working?</span>
                        <i class="fas" :class="active === 3 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                    </button>

                    <div x-show="active === 3" x-cloak class="p-4 bg-white">
                        <p class="text-gray-600">
                            If your tracking number isn't working, it may be because: 1) The shipment was just created and hasn't been scanned into our system yet, 2) There might be a typo in the tracking number, or 3) The system might be experiencing temporary issues. Try again in a few hours or contact our customer support for assistance.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 4 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <button
                        @click="active = active === 4 ? null : 4"
                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"
                    >
                        <span>Can I track multiple shipments at once?</span>
                        <i class="fas" :class="active === 4 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                    </button>

                    <div x-show="active === 4" x-cloak class="p-4 bg-white">
                        <p class="text-gray-600">
                            Currently, our tracking system allows you to track one shipment at a time. For tracking multiple shipments, you'll need to enter each tracking number separately. If you frequently track multiple shipments, consider creating an account for easier management.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="py-12 bg-secondary relative">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="mb-6 md:mb-0">
                <h2 class="text-2xl md:text-3xl font-bold text-white">Need Help With Your Tracking?</h2>
                <p class="text-white text-opacity-90 mt-2">Our customer support team is ready to assist you!</p>
            </div>
            <div class="flex flex-wrap gap-4">
                <a href="contact" class="bg-white text-secondary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i class="fas fa-phone-alt mr-2"></i>
                    Contact Support
                </a>
                <a href="request-quote" class="bg-primary text-white hover:bg-opacity-90 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i class="fas fa-shipping-fast mr-2"></i>
                    Get a Quote
                </a>
            </div>
        </div>
    </div>

    <!-- Wave Pattern Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 48" class="text-white fill-current">
            <path d="M0,0L48,8C96,16,192,32,288,32C384,32,480,16,576,16C672,16,768,32,864,37.3C960,43,1056,37,1152,32C1248,27,1344,21,1392,18.7L1440,16L1440,48L1392,48C1344,48,1248,48,1152,48C1056,48,960,48,864,48C768,48,672,48,576,48C480,48,384,48,288,48C192,48,96,48,48,48L0,48Z"></path>
        </svg>
    </div>
</section>

<?php $__env->startPush('scripts'); ?>
<script>
    // Fix Font Awesome icons visibility
    document.addEventListener('DOMContentLoaded', function() {
        // Ensure all Font Awesome icons are visible
        ensureIconsAreVisible();

        // Set up MutationObserver to monitor DOM changes by Alpine.js
        const observer = new MutationObserver(function(mutations) {
            ensureIconsAreVisible();
        });

        // Start observing the document with the configured parameters
        observer.observe(document.body, {
            childList: true,
            subtree: true,
            attributes: true,
            attributeFilter: ['style', 'class']
        });

        function ensureIconsAreVisible() {
            // Force display of all Font Awesome icons
            document.querySelectorAll('.fas, .fab, .far, .fa, .fa-icon').forEach(function(icon) {
                icon.style.display = 'inline-block';
                icon.style.visibility = 'visible';
                icon.style.opacity = '1';

                // Make sure icon color has good contrast with background
                // This helps prevent icons from "disappearing" when their color matches the background
                const parent = icon.parentElement;
                if (parent) {
                    const parentBg = window.getComputedStyle(parent).backgroundColor;
                    if (parentBg && parentBg !== 'transparent' && parentBg !== 'rgba(0, 0, 0, 0)') {
                        // Use a contrasting color based on background
                        icon.style.color = isLightColor(parentBg) ? '#0A1F44' : '#ffffff';
                    }
                }
            });
        }

        // Helper function to determine if a color is light or dark
        function isLightColor(color) {
            // Simple check for light colors
            return /rgba?\((\d+),\s*(\d+),\s*(\d+)/.test(color) &&
                   RegExp.$1 > 180 && RegExp.$2 > 180 && RegExp.$3 > 180;
        }

        // Additional fix: periodically check if icons are visible
        setInterval(ensureIconsAreVisible, 1000);

        // --- CSRF Token Auto-Refresh ---
        function refreshCsrfToken() {
            fetch('/refresh-csrf').then(function(response) {
                return response.json();
            }).then(function(data) {
                if (data.csrfToken) {
                    document.querySelectorAll('input[name="_token"]').forEach(function(input) {
                        input.value = data.csrfToken;
                    });
                }
            });
        }
        // Refresh CSRF token every 10 minutes (600000 ms)
        setInterval(refreshCsrfToken, 600000);
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/acefinca/translandlogisticoservices.sbs/resources/views/home/track-order.blade.php ENDPATH**/ ?>