<?php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
?>



<?php $__env->startSection('title', $settings->site_title); ?>

<?php $__env->startSection('styles'); ?>
<?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
<style>
    /* Force icons to always display */
    [data-lucide] {
        display: inline-block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    /* Make sure icons on primary backgrounds are visible */
    .bg-primary [data-lucide], 
    .bg-secondary [data-lucide] {
        color: white !important;
    }
    
    /* Custom list styling for terms and conditions */
    .terms-list li {
        position: relative;
        padding-left: 1.75rem;
        margin-bottom: 0.75rem;
        line-height: 1.6;
    }
    
    .terms-list li::before {
        content: '';
        position: absolute;
        left: 0;
        top: 0.5rem;
        width: 0.5rem;
        height: 0.5rem;
        background-color: var(--primary-color);
        border-radius: 50%;
    }
    
    /* Smooth scrolling for anchor links */
    html {
        scroll-behavior: smooth;
    }
    
    /* Print styles */
    @media  print {
        header, footer, .no-print {
            display: none !important;
        }
        
        body {
            font-size: 12pt;
            color: #000;
            background-color: #fff;
        }
        
        .container {
            max-width: 100% !important;
            width: 100% !important;
        }
        
        .terms-content {
            padding: 0 !important;
            margin: 0 !important;
            box-shadow: none !important;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<section class="relative bg-secondary py-16">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute inset-0 bg-secondary bg-opacity-90"></div>
        <div class="absolute w-96 h-96 -top-20 -left-20 bg-white opacity-5 rounded-full"></div>
        <div class="absolute w-96 h-96 bottom-0 right-0 bg-primary opacity-5 rounded-full"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col items-center">
            <h1 class="text-3xl md:text-4xl font-bold text-white mb-4">Terms and Conditions</h1>
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="flex items-center space-x-2 text-sm text-white">
                    <li>
                        <a href="/" class="hover:text-primary transition-all">Home</a>
                    </li>
                    <li class="flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mx-1">
                            <polyline points="9 18 15 12 9 6"></polyline>
                        </svg>
                        <span class="text-white">Terms and Conditions</span>
                    </li>
                </ol>
            </nav>
        </div>
    </div>
    
    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>
        </svg>
    </div>
</section>

<!-- Terms & Conditions Content -->
<section class="py-16" x-data="{ activeSection: 'overview', printMode: false }">
    <div class="container mx-auto px-4">
        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Sidebar Navigation -->
            <div class="lg:w-1/4 order-2 lg:order-1">
                <div class="sticky top-8 bg-white rounded-lg shadow-md p-6 no-print">
                    <h3 class="text-lg font-bold text-secondary mb-4 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                            <polyline points="14 2 14 8 20 8"></polyline>
                            <line x1="16" y1="13" x2="8" y2="13"></line>
                            <line x1="16" y1="17" x2="8" y2="17"></line>
                            <polyline points="10 9 9 9 8 9"></polyline>
                        </svg>
                        Document Sections
                    </h3>
                    
                    <nav class="space-y-2">
                        <a @click="activeSection = 'overview'" :class="{'bg-primary text-white': activeSection === 'overview', 'hover:bg-gray-100': activeSection !== 'overview'}" class="block px-4 py-2 rounded-md cursor-pointer transition-all text-sm font-medium flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                <circle cx="12" cy="12" r="10"></circle>
                                <line x1="12" y1="16" x2="12" y2="12"></line>
                                <line x1="12" y1="8" x2="12.01" y2="8"></line>
                            </svg>
                            Overview
                        </a>
                        
                        <a @click="activeSection = 'intellectual-property'" :class="{'bg-primary text-white': activeSection === 'intellectual-property', 'hover:bg-gray-100': activeSection !== 'intellectual-property'}" class="block px-4 py-2 rounded-md cursor-pointer transition-all text-sm font-medium flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                <circle cx="12" cy="12" r="10"></circle>
                                <polygon points="16.24 7.76 14.12 14.12 7.76 16.24 9.88 9.88 16.24 7.76"></polygon>
                            </svg>
                            Intellectual Property
                        </a>
                        
                        <a @click="activeSection = 'permissions'" :class="{'bg-primary text-white': activeSection === 'permissions', 'hover:bg-gray-100': activeSection !== 'permissions'}" class="block px-4 py-2 rounded-md cursor-pointer transition-all text-sm font-medium flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path>
                            </svg>
                            Permissions
                        </a>
                        
                        <a @click="activeSection = 'restrictions'" :class="{'bg-primary text-white': activeSection === 'restrictions', 'hover:bg-gray-100': activeSection !== 'restrictions'}" class="block px-4 py-2 rounded-md cursor-pointer transition-all text-sm font-medium flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                <circle cx="12" cy="12" r="10"></circle>
                                <line x1="4.93" y1="4.93" x2="19.07" y2="19.07"></line>
                            </svg>
                            Restrictions
                        </a>
                        
                        <a @click="activeSection = 'linking'" :class="{'bg-primary text-white': activeSection === 'linking', 'hover:bg-gray-100': activeSection !== 'linking'}" class="block px-4 py-2 rounded-md cursor-pointer transition-all text-sm font-medium flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                <path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path>
                                <path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path>
                            </svg>
                            Linking
                        </a>
                        
                        <a @click="activeSection = 'changes'" :class="{'bg-primary text-white': activeSection === 'changes', 'hover:bg-gray-100': activeSection !== 'changes'}" class="block px-4 py-2 rounded-md cursor-pointer transition-all text-sm font-medium flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                <polyline points="23 4 23 10 17 10"></polyline>
                                <polyline points="1 20 1 14 7 14"></polyline>
                                <path d="M3.51 9a9 9 0 0 1 14.85-3.36L23 10M1 14l4.64 4.36A9 9 0 0 0 20.49 15"></path>
                            </svg>
                            Changes
                        </a>
                        
                        <a @click="activeSection = 'operation'" :class="{'bg-primary text-white': activeSection === 'operation', 'hover:bg-gray-100': activeSection !== 'operation'}" class="block px-4 py-2 rounded-md cursor-pointer transition-all text-sm font-medium flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                                <line x1="8" y1="21" x2="16" y2="21"></line>
                                <line x1="12" y1="17" x2="12" y2="21"></line>
                            </svg>
                            Website Operation
                        </a>
                        
                        <a @click="activeSection = 'complaints'" :class="{'bg-primary text-white': activeSection === 'complaints', 'hover:bg-gray-100': activeSection !== 'complaints'}" class="block px-4 py-2 rounded-md cursor-pointer transition-all text-sm font-medium flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                            </svg>
                            Complaints
                        </a>
                        
                        <a @click="activeSection = 'jurisdiction'" :class="{'bg-primary text-white': activeSection === 'jurisdiction', 'hover:bg-gray-100': activeSection !== 'jurisdiction'}" class="block px-4 py-2 rounded-md cursor-pointer transition-all text-sm font-medium flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                <polygon points="12 2 2 7 12 12 22 7 12 2"></polygon>
                                <polyline points="2 17 12 22 22 17"></polyline>
                                <polyline points="2 12 12 17 22 12"></polyline>
                            </svg>
                            Jurisdiction
                        </a>
                    </nav>
                    
                    <div class="mt-8 pt-4 border-t border-gray-200">
                        <h4 class="text-sm font-semibold text-secondary mb-3">Document Actions</h4>
                        
                        <div class="space-y-3">
                            <button @click="window.print()" class="w-full flex items-center justify-center px-4 py-2 bg-gray-100 hover:bg-gray-200 rounded-md transition-all text-sm font-medium">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                    <polyline points="6 9 6 2 18 2 18 9"></polyline>
                                    <path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path>
                                    <rect x="6" y="14" width="12" height="8"></rect>
                                </svg>
                                Print Document
                            </button>
                            
                            <button @click="printMode = true; setTimeout(() => {window.print(); printMode = false;}, 100)" class="w-full flex items-center justify-center px-4 py-2 bg-gray-100 hover:bg-gray-200 rounded-md transition-all text-sm font-medium">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                    <polyline points="14 2 14 8 20 8"></polyline>
                                    <line x1="12" y1="18" x2="12" y2="12"></line>
                                    <line x1="9" y1="15" x2="15" y2="15"></line>
                                </svg>
                                Save as PDF
                            </button>
                        </div>
                        
                        <div class="mt-6">
                            <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded">
                                <div class="flex">
                                    <div class="flex-shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-400">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <line x1="12" y1="16" x2="12" y2="12"></line>
                                            <line x1="12" y1="8" x2="12.01" y2="8"></line>
                                        </svg>
                                    </div>
                                    <div class="ml-3">
                                        <p class="text-sm text-blue-700">
                                            These terms were last updated on <strong>August 24, 2025</strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="lg:w-3/4 order-1 lg:order-2">
                <div class="bg-white rounded-lg shadow-md p-6 md:p-8 terms-content">
                    <div class="flex items-center justify-between mb-6 pb-4 border-b border-gray-200">
                        <h2 class="text-2xl md:text-3xl font-bold text-secondary">Terms and Conditions</h2>
                        <div class="flex items-center text-sm text-gray-500 no-print">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-1">
                                <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                <line x1="16" y1="2" x2="16" y2="6"></line>
                                <line x1="8" y1="2" x2="8" y2="6"></line>
                                <line x1="3" y1="10" x2="21" y2="10"></line>
                            </svg>
                            Last Updated: August 24, 2025
                        </div>
                    </div>
                    
                    <!-- Overview Section -->
                    <div x-show="activeSection === 'overview'" class="mb-8">
                        <div class="prose max-w-none text-gray-700">
                            <p class="mb-4">
                                Welcome to <a href="<?php echo e($settings->site_address); ?>" class="text-primary hover:underline"><?php echo e($settings->site_name); ?></a>. 
                                This website is owned and operated by Transport Services Limited and <?php echo e($settings->site_name); ?>.
                            </p>
                            
                            <p class="mb-4">
                                Information therein is for historical purposes only and that while information contained within the releases 
                                was believed to be accurate at the time of issue, the Company will not, and specifically disclaims any duty to, 
                                update this information.
                            </p>
                            
                            <p class="mb-4">
                                Visitors to this website are bound by the following terms and conditions so please read these carefully before going on. 
                                For the purposes of these terms and conditions, "this website" means the following parts of the 
                                <a href="<?php echo e($settings->site_url); ?>" class="text-primary hover:underline"><?php echo e($settings->site_name); ?></a>.
                            </p>
                            
                            <div class="bg-gray-50 p-4 rounded-lg my-6">
                                <p class="italic text-gray-600 text-sm">
                                    By accessing and using this website, you acknowledge that you have read, understood, and agree to be bound by 
                                    these Terms and Conditions. If you do not agree with any part of these terms, please do not use our website 
                                    or services.
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Intellectual Property Section -->
                    <div x-show="activeSection === 'intellectual-property'" class="mb-8" x-cloak>
                        <h3 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <polygon points="16.24 7.76 14.12 14.12 7.76 16.24 9.88 9.88 16.24 7.76"></polygon>
                            </svg>
                            Intellectual Property
                        </h3>
                        
                        <div class="prose max-w-none text-gray-700">
                            <ul class="terms-list mt-4">
                                <li>This website contains material including text, photographs and other images and sound, which is protected by copyright and/or other intellectual property rights. All copyright and other intellectual property rights in this material are either owned by <?php echo e($settings->site_name); ?> or have been licensed to it by the owner(s) of those rights so that it can use this material as part of this website.</li>
                                <li>This website also contains trade marks, including the mark <?php echo e($settings->site_name); ?>" and the <?php echo e($settings->site_name); ?> logo. All trade marks included on this website belong to <?php echo e($settings->site_name); ?> or have been licensed to it by the owner(s) of those trade marks for use on this website.</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Permissions Section -->
                    <div x-show="activeSection === 'permissions'" class="mb-8" x-cloak>
                        <h3 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path>
                            </svg>
                            Permissions
                        </h3>
                        
                        <div class="prose max-w-none text-gray-700">
                            <p class="font-medium mb-2">You may:</p>
                            <ul class="terms-list">
                                <li>access any part of the website;</li>
                                <li>print off one copy of any or all of the pages for your own personal reference.</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Restrictions Section -->
                    <div x-show="activeSection === 'restrictions'" class="mb-8" x-cloak>
                        <h3 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <line x1="4.93" y1="4.93" x2="19.07" y2="19.07"></line>
                            </svg>
                            Restrictions
                        </h3>
                        
                        <div class="prose max-w-none text-gray-700">
                            <p class="font-medium mb-2">You may not:</p>
                            <ul class="terms-list">
                                <li>copy (whether by printing off onto paper, storing on disk, downloading or in any other way), distribute (including distributing copies), broadcast, alter or tamper with in any way or otherwise use any material contained in the website except as set out under "You may". These restrictions apply in relation to all or part of the material on the website;</li>
                                <li>remove any copyright, trade mark or other intellectual property notices contained in the original material from any material copied or printed off from the website; without our express written consent.</li>
                            </ul>
                            
                            <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 rounded my-6">
                                <div class="flex">
                                    <div class="flex-shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-400">
                                            <path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path>
                                            <line x1="12" y1="9" x2="12" y2="13"></line>
                                            <line x1="12" y1="17" x2="12.01" y2="17"></line>
                                        </svg>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-sm font-medium text-yellow-800">Important Notice</h3>
                                        <p class="text-sm text-yellow-700 mt-1">
                                            Unauthorized use of our website content may result in legal action. If you wish to use content beyond 
                                            personal reference, please contact us for permission.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Linking Section -->
                    <div x-show="activeSection === 'linking'" class="mb-8" x-cloak>
                        <h3 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                <path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path>
                                <path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path>
                            </svg>
                            Linking
                        </h3>
                        
                        <div class="prose max-w-none text-gray-700">
                            <p class="mb-4">
                                If you wish to provide a hypertext or other link to this website, please email the 
                                <a href="mailto:<?php echo e($settings->contact_email); ?>" class="text-primary hover:underline font-medium">Webmaster</a> 
                                and we will consider your request. It is our decision as to whether we agree to your request and we do not have to do so.
                            </p>
                            
                            <div class="bg-gray-50 p-4 rounded-lg my-6">
                                <h4 class="font-medium mb-2">Guidelines for Linking:</h4>
                                <ul class="text-sm space-y-2">
                                    <li>• Links must not damage our reputation or take advantage of it</li>
                                    <li>• Links must not imply any form of association where none exists</li>
                                    <li>• Links must not display our content in frames that alter its appearance</li>
                                    <li>• Links must not suggest endorsement without prior written approval</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Changes to Terms Section -->
                    <div x-show="activeSection === 'changes'" class="mb-8" x-cloak>
                        <h3 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                <polyline points="23 4 23 10 17 10"></polyline>
                                <polyline points="1 20 1 14 7 14"></polyline>
                                <path d="M3.51 9a9 9 0 0 1 14.85-3.36L23 10M1 14l4.64 4.36A9 9 0 0 0 20.49 15"></path>
                            </svg>
                            Changes to Terms and Conditions
                        </h3>
                        
                        <div class="prose max-w-none text-gray-700">
                            <ul class="terms-list">
                                <li><?php echo e($settings->site_name); ?> may change the terms and conditions and disclaimer set out above from time to time. By browsing this website you are accepting that you are bound by the current terms and conditions and disclaimer and so you should check these each time you revisit the site.</li>
                            </ul>
                            
                            <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded my-6">
                                <div class="flex">
                                    <div class="flex-shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-400">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <line x1="12" y1="16" x2="12" y2="12"></line>
                                            <line x1="12" y1="8" x2="12.01" y2="8"></line>
                                        </svg>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-sm font-medium text-blue-800">Notification of Changes</h3>
                                        <p class="text-sm text-blue-700 mt-1">
                                            While we may attempt to notify users of significant changes to these terms, it remains your responsibility 
                                            to review them periodically for updates. Your continued use of our website after changes constitutes 
                                            acceptance of the revised terms.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Website Operation Section -->
                    <div x-show="activeSection === 'operation'" class="mb-8" x-cloak>
                        <h3 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                                <line x1="8" y1="21" x2="16" y2="21"></line>
                                <line x1="12" y1="17" x2="12" y2="21"></line>
                            </svg>
                            Changes to/Operation of Website
                        </h3>
                        
                        <div class="prose max-w-none text-gray-700">
                            <ul class="terms-list">
                                <li><?php echo e($settings->site_name); ?> may change the format and content of this website at any time.</li>
                                <li><?php echo e($settings->site_name); ?> may suspend the operation of this website for support or maintenance work, in order to update the content or for any other reason.</li>
                                <li><?php echo e($settings->site_name); ?> reserves the right to terminate access to this website at any time and without notice.</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Complaints Section -->
                    <div x-show="activeSection === 'complaints'" class="mb-8" x-cloak>
                        <h3 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                            </svg>
                            Complaints Procedure
                        </h3>
                        
                        <div class="prose max-w-none text-gray-700">
                            <p class="mb-4">
                                If you have a question or complaint about this website, please 
                                <a href="mailto:<?php echo e($settings->contact_email); ?>" class="text-primary hover:underline font-medium">
                                    contact the <?php echo e($settings->site_name); ?> webmaster
                                </a>.
                            </p>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-6">
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <h4 class="font-medium text-secondary mb-2 flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                                            <polyline points="22,6 12,13 2,6"></polyline>
                                        </svg>
                                        Email Support
                                    </h4>
                                    <p class="text-sm text-gray-600">
                                        For general inquiries or complaints:<br>
                                        <a href="mailto:<?php echo e($settings->contact_email); ?>" class="text-primary"><?php echo e($settings->contact_email); ?></a>
                                    </p>
                                </div>
                                
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <h4 class="font-medium text-secondary mb-2 flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                            <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                                        </svg>
                                        Phone Support
                                    </h4>
                                    <p class="text-sm text-gray-600">
                                        Customer service:<br>
                                        <?php echo e($settings->whatsapp); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Jurisdiction Section -->
                    <div x-show="activeSection === 'jurisdiction'" class="mb-8" x-cloak>
                        <h3 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-primary">
                                <polygon points="12 2 2 7 12 12 22 7 12 2"></polygon>
                                <polyline points="2 17 12 22 22 17"></polyline>
                                <polyline points="2 12 12 17 22 12"></polyline>
                            </svg>
                            Jurisdiction
                        </h3>
                        
                        <div class="prose max-w-none text-gray-700">
                            <ul class="terms-list">
                                <li>These terms and conditions are governed by and to be interpreted in accordance with US law and in the event of any dispute arising in relation to these terms and conditions or any dispute arising in relation to the website whether in contract or tort or otherwise the US courts will have non-exclusive jurisdiction over such.</li>
                            </ul>
                            
                            <div class="bg-gray-50 p-4 rounded-lg my-6">
                                <h4 class="font-medium mb-2">Governing Law Summary:</h4>
                                <ul class="text-sm space-y-2">
                                    <li>• These terms are governed by US law</li>
                                    <li>• Any disputes will be handled in US courts</li>
                                    <li>• US courts have non-exclusive jurisdiction</li>
                                    <li>• This applies to all website-related disputes, whether in contract or tort</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Agreement Section -->
                    <div class="mt-10 pt-8 border-t border-gray-200">
                        <div class="bg-gray-50 p-6 rounded-lg">
                            <h3 class="text-lg font-bold text-secondary mb-4">Acceptance of Terms</h3>
                            <p class="text-gray-700 mb-4">
                                By using this website, you acknowledge that you have read, understood, and agree to be bound by these Terms and Conditions.
                                If you do not agree to these terms, please discontinue use of this website immediately.
                            </p>
                            
                            <div class="flex items-center justify-between mt-6">
                                <div class="text-sm text-gray-500">Last Updated: August 24, 2025</div>
                                <a href="contact" class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-primary hover:bg-secondary transition-all duration-300 no-print">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                                    </svg>
                                    Contact Us
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="py-12 bg-secondary relative no-print">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="mb-6 md:mb-0">
                <h2 class="text-2xl md:text-3xl font-bold text-white">Need Help With Shipping?</h2>
                <p class="text-white text-opacity-90 mt-2">Let us help you with your logistics and delivery needs!</p>
            </div>
            <div class="flex flex-wrap gap-4">
                <a href="/services" class="bg-white text-secondary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-secondary">
                        <polygon points="12 2 2 7 12 12 22 7 12 2"></polygon>
                        <polyline points="2 17 12 22 22 17"></polyline>
                        <polyline points="2 12 12 17 22 12"></polyline>
                    </svg>
                    View Our Services
                </a>
                <a href="contact" class="bg-primary text-white hover:bg-opacity-90 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 text-white">
                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                    </svg>
                    Contact Us
                </a>
            </div>
        </div>
    </div>
    
    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 48" class="text-white fill-current">
            <path d="M0,0L48,8C96,16,192,32,288,32C384,32,480,16,576,16C672,16,768,32,864,37.3C960,43,1056,37,1152,32C1248,27,1344,21,1392,18.7L1440,16L1440,48L1392,48C1344,48,1248,48,1152,48C1056,48,960,48,864,48C768,48,672,48,576,48C480,48,384,48,288,48C192,48,96,48,48,48L0,48Z"></path>
        </svg>
    </div>
</section>

<?php $__env->startPush('scripts'); ?>
<script>
    // Fix Lucide icons visibility
    document.addEventListener('DOMContentLoaded', function() {
        // Ensure all icons are visible
        ensureIconsAreVisible();
        
        // Set up MutationObserver to monitor DOM changes by Alpine.js
        const observer = new MutationObserver(function(mutations) {
            ensureIconsAreVisible();
        });
        
        // Start observing the document with the configured parameters
        observer.observe(document.body, { 
            childList: true, 
            subtree: true,
            attributes: true,
            attributeFilter: ['style', 'class']
        });
        
        function ensureIconsAreVisible() {
            // Force display of all icons
            document.querySelectorAll('[data-lucide]').forEach(function(icon) {
                icon.style.display = 'inline-block';
                icon.style.visibility = 'visible';
                icon.style.opacity = '1';
                
                // Fix for icons in specific backgrounds
                const parent = icon.closest('.bg-primary, .bg-secondary');
                if (parent) {
                    icon.style.color = '#ffffff';
                }
            });
        }
        
        // Additional fix: periodically check if icons are visible
        setInterval(ensureIconsAreVisible, 1000);
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/acefinca/translandlogisticoservices.sbs/resources/views/home/terms.blade.php ENDPATH**/ ?>