
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="<?php echo e(asset('storage/app/public/'.$settings->favicon)); ?>" type="image/x-icon">
    <meta name="author" content="">
    <meta name="description" content="Professional Logistic, Delivery and Transportation Services">
    <meta name="keywords" content="logistic, transportation, package, delivery, cargo, courier, tracking, shipping">

    <title><?php echo e($settings->site_name); ?> - Logistic, Delivery and Transportation</title>

    <!-- Tailwind CSS -->

    <link href="https://unpkg.com/tailwindcss@^2.0/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"  />

    <!-- Custom CSS -->
    <link href="temp/custom/css/custom-style.css" rel="stylesheet">
    <link href="temp/custom/css/original-colors.css" rel="stylesheet">
    <link href="temp/custom/css/lucide-fallbacks.css" rel="stylesheet">

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <!-- Alpine.js -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <style>
        /* Alpine.js x-cloak directive */
        [x-cloak] {
            display: none !important;
        }

        /* Custom transitions */
        .transition-nav {
            transition: all 0.3s ease;
        }

        /* Original brand color scheme */
  :root {
    /* Primary Brand Color - Energetic and Bold */
    --primary-color: #FF4D00; /* Bright Orange/Red for call-to-actions and highlights */

    /* Secondary Brand Color - Professional and Trustworthy */
    --secondary-color: #0A1F44; /* Deep Navy for headers, menus, and important text */

    /* Accent Color - For hover states and smaller highlights */
    --accent-color: #1F6FEB; /* Vivid Blue for links, icons, and emphasis */

    /* Supporting Colors */
    --background-color: #F9FAFC; /* Light background for readability */
    --text-color: #333333; /* Default text color */
    --success-color: #28A745; /* For delivered/shipped states */
    --warning-color: #FFC107; /* For pending or in-transit */
    --danger-color: #DC3545; /* For failed or returned items */
}




        .bg-primary {
            background-color: var(--primary-color);
        }

        .bg-secondary {
            background-color: var(--secondary-color);
        }

        .text-primary {
            color: var(--primary-color)
        }

        .text-secondary {
            color: var(--secondary-color);
        }

        .border-primary {
            border-color: var(--primary-color);
        }

        .hover\:bg-primary-dark:hover {
            background-color: var(--primary-color);
        }

        /* Hero section gradient */
        .bg-hero-gradient {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--accent-color) 100%);
        }

        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        ::-webkit-scrollbar-thumb {
            background: var(--primary-color);
            border-radius: 10px;
        }

        /* Custom animations */
        .animate-float {
            animation: float 3s infinite ease-in-out;
        }

        @keyframes  float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
    </style>
    <!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '214e1dfe1194c261c6c4f2d0399aa5c8c6d03520';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>

</head>


































<body class="antialiased bg-gray-50">
    <!-- Barra superior de anuncio -->
    <div class="bg-secondary text-white text-xs md:text-sm py-2">
        <div class="container mx-auto px-4 flex flex-col sm:flex-row justify-between items-center">
            <div class="flex items-center space-x-4">
                <!--<div id="google_translate_element" class="min-w-[120px]"></div>-->
            </div>
            <div class="flex items-center space-x-6 mt-2 sm:mt-0">
                <span class="flex items-center">
                    <i data-lucide="phone" class="w-4 h-4 mr-1"></i>
                    <?php echo e($settings->whatsapp); ?>

                </span>
                <span class="flex items-center">
                    <i data-lucide="mail" class="w-4 h-4 mr-1"></i>
                    <?php echo e($settings->contact_email); ?>

                </span>
            </div>
        </div>
    </div>

    <!-- Encabezado principal -->
    <header class="bg-white shadow-sm" x-data="{ mobileMenuOpen: false }">
        <div class="container mx-auto px-4">
            <!-- Logo y navegación -->
            <div class="flex justify-between items-center py-4">
                <!-- Logo -->
                <a href="/" class="flex items-center space-x-2">
                    <img src="<?php echo e(asset('storage/app/public/'.$settings->logo)); ?>" alt="<?php echo e($settings->site_name); ?>" class="h-10 md:h-12">
                </a>

                <!-- Navegación de escritorio -->
                <nav class="hidden lg:flex items-center space-x-1">
                    <a href="/" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">INICIO</a>
                    <a href="<?php echo e(route('track-order')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">RASTREAR PEDIDO</a>
                    <a href="<?php echo e(route('request-quote')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">SOLICITAR COTIZACIÓN</a>
                    <a href="<?php echo e(route('about')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">SOBRE NOSOTROS</a>
                    <a href="<?php echo e(route('services')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">SERVICIOS</a>
                    <a href="<?php echo e(route('contact')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">CONTÁCTENOS</a>
                </nav>

                <!-- Botón de menú móvil -->
                <button
                    class="lg:hidden flex items-center p-2 rounded-md text-secondary"
                    @click="mobileMenuOpen = !mobileMenuOpen"
                >
                    <i data-lucide="menu" class="w-6 h-6" x-show="!mobileMenuOpen" x-cloak></i>
                    <i data-lucide="x" class="w-6 h-6" x-show="mobileMenuOpen" x-cloak></i>
                </button>
            </div>

            <!-- Barra de información de la empresa -->
            <div class="hidden md:flex items-center justify-between py-3 border-t border-gray-200">
                <div class="flex items-center space-x-4">
                    <div class="flex items-start space-x-2">
                        <i data-lucide="clock" class="w-8 h-8 text-primary"></i>
                        <div>
                            <p class="text-xs text-gray-500">HORARIO DE ATENCIÓN</p>
                            <p class="font-medium text-sm">LUN-VIE 07:00 - 18:00</p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-2">
                        <i data-lucide="map-pin" class="w-8 h-8 text-primary"></i>
                        <div>
                            <p class="text-xs text-gray-500">NUESTRA UBICACIÓN</p>
                            <p class="font-medium text-sm"><?php echo e($settings->locations); ?></p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-2">
                        <i data-lucide="headphones" class="w-8 h-8 text-primary"></i>
                        <div>
                            <p class="text-xs text-gray-500">SOPORTE RÁPIDO</p>
                            <p class="font-medium text-sm"><?php echo e($settings->contact_email); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Íconos sociales -->
                <div class="flex items-center space-x-3">
                    <a href="#" class="text-secondary hover:text-primary transition-nav">
                        <i data-lucide="facebook" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary transition-nav">
                        <i data-lucide="twitter" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary transition-nav">
                        <i data-lucide="instagram" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary transition-nav">
                        <i data-lucide="linkedin" class="w-5 h-5"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Menú de navegación móvil -->
        <div x-show="mobileMenuOpen"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0 scale-95"
            x-transition:enter-end="opacity-100 scale-100"
            x-transition:leave="transition ease-in duration-150"
            x-transition:leave-start="opacity-100 scale-100"
            x-transition:leave-end="opacity-0 scale-95"
            class="lg:hidden bg-white border-t border-gray-200"
            x-cloak
        >
            <div class="px-4 py-2 space-y-1">
                <a href="/" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">INICIO</a>
                <a href="track-order" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">RASTREAR PEDIDO</a>
                <a href="request-quote" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">SOLICITAR COTIZACIÓN</a>
                <a href="about" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">SOBRE NOSOTROS</a>
                <a href="services" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">SERVICIOS</a>
                <a href="contact" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">CONTÁCTENOS</a>
            </div>

            <div class="px-4 py-3 border-t border-gray-200">
                <div class="flex flex-col space-y-3">
                    <div class="flex items-center space-x-2">
                        <i data-lucide="clock" class="w-5 h-5 text-primary"></i>
                        <span class="text-sm">LUN-VIE 07:00 - 18:00</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <i data-lucide="map-pin" class="w-5 h-5 text-primary"></i>
                        <span class="text-sm"><?php echo e($settings->locations); ?></span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <i data-lucide="headphones" class="w-5 h-5 text-primary"></i>
                        <span class="text-sm"><?php echo e($settings->contact_email); ?></span>
                    </div>
                </div>

                <div class="flex items-center space-x-4 mt-4">
                    <a href="#" class="text-secondary hover:text-primary">
                        <i data-lucide="facebook" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary">
                        <i data-lucide="twitter" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary">
                        <i data-lucide="instagram" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary">
                        <i data-lucide="linkedin" class="w-5 h-5"></i>
                    </a>
                </div>
            </div>
        </div>
    </header>

    <?php if(Session::has('error')): ?>
    <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 my-4 mx-auto max-w-7xl" role="alert">
        <div class="flex">
            <div class="flex-shrink-0">
                <i data-lucide="alert-triangle" class="h-5 w-5 text-red-500"></i>
            </div>
            <div class="ml-3">
                <p class="font-medium">¡Error! Has ingresado un número de seguimiento incorrecto.</p>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Pie de página -->
    <footer class="bg-secondary text-white pt-16">
        <div class="container mx-auto px-4">
            <!-- Contenido del pie -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Sección sobre nosotros -->
                <div>
                    <h3 class="text-lg font-bold mb-4 flex items-center">
                        <span class="bg-primary text-white rounded-full w-6 h-6 inline-flex items-center justify-center mr-2 text-sm">01</span>
                        SOBRE NOSOTROS
                    </h3>
                    <p class="text-gray-300 mb-6">Puedes usar los íconos de arriba para acceder a más información sobre nuestras credenciales, ofreciendo soluciones en una variedad de industrias específicas. Sin embargo, estas están lejos de ser las únicas industrias que <?php echo e($settings->site_name); ?> ha atendido con orgullo.</p>
                    <div class="flex space-x-3">
                        <a href="#" class="bg-gray-700 hover:bg-primary p-2 rounded-full transition-nav">
                            <i data-lucide="facebook" class="w-4 h-4"></i>
                        </a>
                        <a href="#" class="bg-gray-700 hover:bg-primary p-2 rounded-full transition-nav">
                            <i data-lucide="twitter" class="w-4 h-4"></i>
                        </a>
                        <a href="#" class="bg-gray-700 hover:bg-primary p-2 rounded-full transition-nav">
                            <i data-lucide="instagram" class="w-4 h-4"></i>
                        </a>
                        <a href="#" class="bg-gray-700 hover:bg-primary p-2 rounded-full transition-nav">
                            <i data-lucide="linkedin" class="w-4 h-4"></i>
                        </a>
                    </div>
                </div>

                <!-- Sección de servicios -->
                <div>
                    <h3 class="text-lg font-bold mb-4 flex items-center">
                        <span class="bg-primary text-white rounded-full w-6 h-6 inline-flex items-center justify-center mr-2 text-sm">02</span>
                        SERVICIOS
                    </h3>
                    <ul class="space-y-2">
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Aceon Freight</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Almacenamiento</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Seguridad de Paquetes</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Carga Aérea</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Almacenaje</a></li>
                    </ul>
                </div>

                <!-- Enlaces rápidos -->
                <div>
                    <h3 class="text-lg font-bold mb-4 flex items-center">
                        <span class="bg-primary text-white rounded-full w-6 h-6 inline-flex items-center justify-center mr-2 text-sm">03</span>
                        ENLACES RÁPIDOS
                    </h3>
                    <ul class="space-y-2">
                        <li><a href="<?php echo e(route('about')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Sobre Nosotros</a></li>
                        <li><a href="<?php echo e(route('contact')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Contáctenos</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Servicios</a></li>
                        <li><a href="<?php echo e(route('privacy')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Política de Privacidad</a></li>
                        <li><a href="<?php echo e(route('terms')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Términos y Condiciones</a></li>
                    </ul>
                </div>

                <!-- Aplicación móvil -->
                <div>
                    <h3 class="text-lg font-bold mb-4 flex items-center">
                        <span class="bg-primary text-white rounded-full w-6 h-6 inline-flex items-center justify-center mr-2 text-sm">04</span>
                        APLICACIÓN MÓVIL
                    </h3>
                    <p class="text-gray-300 mb-4">Descarga nuestras aplicaciones móviles desde Google Play y Apple Store o escanea el código QR que aparece abajo para comenzar a usarlas.</p>
                    <div class="flex flex-wrap gap-2">
                        <img src="temp/custom/images/icon-appstore.png" alt="App Store" class="h-10">
                        <img src="temp/custom/images/icon-googleplay.png" alt="Google Play" class="h-10">
                    </div>
                    <div class="mt-4 flex items-center">
                        <i data-lucide="smartphone" class="w-8 h-8 text-primary mr-3"></i>
                    </div>
                </div>
            </div>

            <!-- Logo y lema del pie -->
            <div class="border-t border-gray-700 mt-12 pt-6 pb-6">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="flex items-center mb-4 md:mb-0">
                        <img src="<?php echo e(asset('storage/app/public/'.$settings->logo)); ?>" alt="<?php echo e($settings->site_name); ?>" class="h-10 mr-4">
                        <h4 class="text-lg font-bold">LOGÍSTICA INTERNACIONAL</h4>
                    </div>
                </div>
            </div>

            <!-- Derechos de autor -->
            <div class="bg-gray-900 py-4 mt-6 -mx-4 px-4">
                <div class="container mx-auto">
                    <p class="text-center text-gray-400 text-sm">
                        Copyright © <?php echo e($settings->year); ?>, <?php echo e($settings->site_name); ?> | LOGÍSTICA
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts conservados -->
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
        }
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
                setTimeout(function() { lucide.createIcons(); }, 500);
            } else {
                console.error('Lucide library not loaded');
                const script = document.createElement('script');
                script.src = 'https://unpkg.com/lucide@latest/dist/umd/lucide.js';
                script.onload = function() {
                    lucide.createIcons();
                    console.log('Lucide loaded and icons created');
                };
                document.head.appendChild(script);
            }
        });
        window.addEventListener('load', function() {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        });
    </script>

    <script src="temp/custom/js/jquery.min.js"></script>
    <script src="temp/custom/js/bootstrap.min.js"></script>
    <script src="temp/custom/js/jquery.validate.min.js"></script>
    <script src="temp/custom/js/jquery.form.js"></script>

    <?php if($settings->tido): ?>
    <script src="//code.tidio.co/<?php echo e($settings->tido); ?>.js" async></script>
    <?php endif; ?>
<?php echo $__env->make('livechat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/acefinca/acirfa-es.sbs/resources/views/layouts/base.blade.php ENDPATH**/ ?>