
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="<?php echo e(asset('storage/app/public/'.$settings->favicon)); ?>" type="image/x-icon">
    <meta name="author" content="">
    <meta name="description" content="Professional Logistic, Delivery and Transportation Services">
    <meta name="keywords" content="logistic, transportation, package, delivery, cargo, courier, tracking, shipping">

    <title><?php echo e($settings->site_name); ?> - Logistic, Delivery and Transportation</title>

    <!-- Tailwind CSS -->

    <link href="https://unpkg.com/tailwindcss@^2.0/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"  />

    <!-- Custom CSS -->
    <link href="temp/custom/css/custom-style.css" rel="stylesheet">
    <link href="temp/custom/css/original-colors.css" rel="stylesheet">
    <link href="temp/custom/css/lucide-fallbacks.css" rel="stylesheet">

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <!-- Alpine.js -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <style>
        /* Alpine.js x-cloak directive */
        [x-cloak] {
            display: none !important;
        }

        /* Custom transitions */
        .transition-nav {
            transition: all 0.3s ease;
        }

        /* Original brand color scheme */
  :root {
    /* Primary Brand Color - Energetic and Bold */
    --primary-color: #FF4D00; /* Bright Orange/Red for call-to-actions and highlights */

    /* Secondary Brand Color - Professional and Trustworthy */
    --secondary-color: #0A1F44; /* Deep Navy for headers, menus, and important text */

    /* Accent Color - For hover states and smaller highlights */
    --accent-color: #1F6FEB; /* Vivid Blue for links, icons, and emphasis */

    /* Supporting Colors */
    --background-color: #F9FAFC; /* Light background for readability */
    --text-color: #333333; /* Default text color */
    --success-color: #28A745; /* For delivered/shipped states */
    --warning-color: #FFC107; /* For pending or in-transit */
    --danger-color: #DC3545; /* For failed or returned items */
}




        .bg-primary {
            background-color: var(--primary-color);
        }

        .bg-secondary {
            background-color: var(--secondary-color);
        }

        .text-primary {
            color: var(--primary-color)
        }

        .text-secondary {
            color: var(--secondary-color);
        }

        .border-primary {
            border-color: var(--primary-color);
        }

        .hover\:bg-primary-dark:hover {
            background-color: var(--primary-color);
        }

        /* Hero section gradient */
        .bg-hero-gradient {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--accent-color) 100%);
        }

        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        ::-webkit-scrollbar-thumb {
            background: var(--primary-color);
            border-radius: 10px;
        }

        /* Custom animations */
        .animate-float {
            animation: float 3s infinite ease-in-out;
        }

        @keyframes  float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
    </style>
</head>

<body class="antialiased bg-gray-50">
    <!-- Top announcement bar -->
    <div class="bg-secondary text-white text-xs md:text-sm py-2">
        <div class="container mx-auto px-4 flex flex-col sm:flex-row justify-between items-center">
            <div class="flex items-center space-x-4">
                <div id="google_translate_element" class="min-w-[120px]"></div>
            </div>
            <div class="flex items-center space-x-6 mt-2 sm:mt-0">
                <span class="flex items-center">
                    <i data-lucide="phone" class="w-4 h-4 mr-1"></i>
                    <?php echo e($settings->whatsapp); ?>

                </span>
                <span class="flex items-center">
                    <i data-lucide="mail" class="w-4 h-4 mr-1"></i>
                    <?php echo e($settings->contact_email); ?>

                </span>
            </div>
        </div>
    </div>

    <!-- Main header -->
    <header class="bg-white shadow-sm" x-data="{ mobileMenuOpen: false }">
        <div class="container mx-auto px-4">
            <!-- Logo and navigation section -->
            <div class="flex justify-between items-center py-4">
                <!-- Logo -->
                <a href="/" class="flex items-center space-x-2">
                    <img src="<?php echo e(asset('storage/app/public/'.$settings->logo)); ?>" alt="<?php echo e($settings->site_name); ?>" class="h-10 md:h-12">
                </a>

                <!-- Desktop Navigation -->
                <nav class="hidden lg:flex items-center space-x-1">
                    <a href="/" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">HOME</a>
                    <a href="<?php echo e(route('track-order')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">TRACK ORDER</a>
                    <a href="<?php echo e(route('request-quote')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">REQUEST QUOTE</a>
                    <a href="<?php echo e(route('about')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">ABOUT US</a>
                    <a href="<?php echo e(route('services')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">SERVICES</a>
                    <a href="<?php echo e(route('contact')); ?>" class="px-4 py-2 font-medium text-secondary hover:text-primary transition-nav">CONTACT US</a>
                </nav>

                <!-- Mobile menu button -->
                <button
                    class="lg:hidden flex items-center p-2 rounded-md text-secondary"
                    @click="mobileMenuOpen = !mobileMenuOpen"
                >
                    <i data-lucide="menu" class="w-6 h-6" x-show="!mobileMenuOpen" x-cloak></i>
                    <i data-lucide="x" class="w-6 h-6" x-show="mobileMenuOpen" x-cloak></i>
                </button>
            </div>

            <!-- Company info bar -->
            <div class="hidden md:flex items-center justify-between py-3 border-t border-gray-200">
                <div class="flex items-center space-x-4">
                    <div class="flex items-start space-x-2">
                        <i data-lucide="clock" class="w-8 h-8 text-primary"></i>
                        <div>
                            <p class="text-xs text-gray-500">OPENING HOURS</p>
                            <p class="font-medium text-sm">MON-FRI 07:00 - 18:00</p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-2">
                        <i data-lucide="map-pin" class="w-8 h-8 text-primary"></i>
                        <div>
                            <p class="text-xs text-gray-500">OUR LOCATION</p>
                            <p class="font-medium text-sm"><?php echo e($settings->locations); ?></p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-2">
                        <i data-lucide="headphones" class="w-8 h-8 text-primary"></i>
                        <div>
                            <p class="text-xs text-gray-500">QUICK SUPPORT</p>
                            <p class="font-medium text-sm"><?php echo e($settings->contact_email); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Social icons -->
                <div class="flex items-center space-x-3">
                    <a href="#" class="text-secondary hover:text-primary transition-nav">
                        <i data-lucide="facebook" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary transition-nav">
                        <i data-lucide="twitter" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary transition-nav">
                        <i data-lucide="instagram" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary transition-nav">
                        <i data-lucide="linkedin" class="w-5 h-5"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Mobile Navigation Menu -->
        <div x-show="mobileMenuOpen"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0 scale-95"
            x-transition:enter-end="opacity-100 scale-100"
            x-transition:leave="transition ease-in duration-150"
            x-transition:leave-start="opacity-100 scale-100"
            x-transition:leave-end="opacity-0 scale-95"
            class="lg:hidden bg-white border-t border-gray-200"
            x-cloak
        >
            <div class="px-4 py-2 space-y-1">
                <a href="/" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">HOME</a>
                <a href="track-order" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">TRACK ORDER</a>
                <a href="request-quote" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">REQUEST QUOTE</a>
                <a href="about" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">ABOUT US</a>
                <a href="services" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">SERVICES</a>
                <a href="contact" class="block px-3 py-2 font-medium text-secondary hover:bg-gray-100 rounded-md">CONTACT US</a>
            </div>

            <div class="px-4 py-3 border-t border-gray-200">
                <div class="flex flex-col space-y-3">
                    <div class="flex items-center space-x-2">
                        <i data-lucide="clock" class="w-5 h-5 text-primary"></i>
                        <span class="text-sm">MON-FRI 07:00 - 18:00</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <i data-lucide="map-pin" class="w-5 h-5 text-primary"></i>
                        <span class="text-sm"><?php echo e($settings->locations); ?></span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <i data-lucide="headphones" class="w-5 h-5 text-primary"></i>
                        <span class="text-sm"><?php echo e($settings->contact_email); ?></span>
                    </div>
                </div>

                <div class="flex items-center space-x-4 mt-4">
                    <a href="#" class="text-secondary hover:text-primary">
                        <i data-lucide="facebook" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary">
                        <i data-lucide="twitter" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary">
                        <i data-lucide="instagram" class="w-5 h-5"></i>
                    </a>
                    <a href="#" class="text-secondary hover:text-primary">
                        <i data-lucide="linkedin" class="w-5 h-5"></i>
                    </a>
                </div>
            </div>
        </div>
    </header>

    <?php if(Session::has('error')): ?>
    <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 my-4 mx-auto max-w-7xl" role="alert">
        <div class="flex">
            <div class="flex-shrink-0">
                <i data-lucide="alert-triangle" class="h-5 w-5 text-red-500"></i>
            </div>
            <div class="ml-3">
                <p class="font-medium">Error! You have entered an incorrect Tracking Number.</p>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="bg-secondary text-white pt-16">
        <div class="container mx-auto px-4">
            <!-- Footer content -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- About section -->
                <div>
                    <h3 class="text-lg font-bold mb-4 flex items-center">
                        <span class="bg-primary text-white rounded-full w-6 h-6 inline-flex items-center justify-center mr-2 text-sm">01</span>
                        ABOUT US
                    </h3>
                    <p class="text-gray-300 mb-6">You can use the icons above to access more information about our credentials, providing solutions in a host of specific industries. However, these are far from the only industries that <?php echo e($settings->site_name); ?> has proudly served.</p>
                    <div class="flex space-x-3">
                        <a href="#" class="bg-gray-700 hover:bg-primary p-2 rounded-full transition-nav">
                            <i data-lucide="facebook" class="w-4 h-4"></i>
                        </a>
                        <a href="#" class="bg-gray-700 hover:bg-primary p-2 rounded-full transition-nav">
                            <i data-lucide="twitter" class="w-4 h-4"></i>
                        </a>
                        <a href="#" class="bg-gray-700 hover:bg-primary p-2 rounded-full transition-nav">
                            <i data-lucide="instagram" class="w-4 h-4"></i>
                        </a>
                        <a href="#" class="bg-gray-700 hover:bg-primary p-2 rounded-full transition-nav">
                            <i data-lucide="linkedin" class="w-4 h-4"></i>
                        </a>
                    </div>
                </div>

                <!-- Services section -->
                <div>
                    <h3 class="text-lg font-bold mb-4 flex items-center">
                        <span class="bg-primary text-white rounded-full w-6 h-6 inline-flex items-center justify-center mr-2 text-sm">02</span>
                        SERVICES
                    </h3>
                    <ul class="space-y-2">
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Aceon Freight</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Storage</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Package Security</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Air Freight</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Warehousing</a></li>
                    </ul>
                </div>

                <!-- Quick Links section -->
                <div>
                    <h3 class="text-lg font-bold mb-4 flex items-center">
                        <span class="bg-primary text-white rounded-full w-6 h-6 inline-flex items-center justify-center mr-2 text-sm">03</span>
                        QUICK LINKS
                    </h3>
                    <ul class="space-y-2">
                        <li><a href="<?php echo e(route('about')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>About Us</a></li>
                        <li><a href="<?php echo e(route('contact')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Contact Us</a></li>
                        <li><a href="<?php echo e(route('services')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Services</a></li>
                        <li><a href="<?php echo e(route('privacy')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Privacy Policy</a></li>
                        <li><a href="<?php echo e(route('terms')); ?>" class="text-gray-300 hover:text-primary transition-nav flex items-center"><i data-lucide="chevron-right" class="w-4 h-4 mr-2"></i>Terms and Conditions</a></li>
                    </ul>
                </div>

                <!-- Mobile App section -->
                <div>
                    <h3 class="text-lg font-bold mb-4 flex items-center">
                        <span class="bg-primary text-white rounded-full w-6 h-6 inline-flex items-center justify-center mr-2 text-sm">04</span>
                        MOBILE APP
                    </h3>
                    <p class="text-gray-300 mb-4">Download our mobile applications from Google Play and Apple Store or decode QR Code just below and start using.</p>
                    <div class="flex flex-wrap gap-2">
                        <img src="temp/custom/images/icon-appstore.png" alt="App Store" class="h-10">
                        <img src="temp/custom/images/icon-googleplay.png" alt="Google Play" class="h-10">
                    </div>
                    <div class="mt-4 flex items-center">
                        <i data-lucide="smartphone" class="w-8 h-8 text-primary mr-3"></i>

                    </div>
                </div>
            </div>

            <!-- Footer logo and tagline -->
            <div class="border-t border-gray-700 mt-12 pt-6 pb-6">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="flex items-center mb-4 md:mb-0">
                        <img src="<?php echo e(asset('storage/app/public/'.$settings->logo)); ?>" alt="<?php echo e($settings->site_name); ?>" class="h-10 mr-4">
                        <h4 class="text-lg font-bold">INTERNATIONAL LOGISTICS</h4>
                    </div>
                </div>
            </div>

            <!-- Copyright -->
            <div class="bg-gray-900 py-4 mt-6 -mx-4 px-4">
                <div class="container mx-auto">
                    <p class="text-center text-gray-400 text-sm">
                        Copyright © <?php echo e($settings->year); ?>, <?php echo e($settings->site_name); ?> | LOGISTICS
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Google Translate Script -->
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
        }
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

    <!-- Initialize Lucide icons -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();

                // Reinitialize icons after a short delay to catch any that might have been missed
                setTimeout(function() {
                    lucide.createIcons();
                }, 500);
            } else {
                console.error('Lucide library not loaded');

                // Attempt to load Lucide if not available
                const script = document.createElement('script');
                script.src = 'https://unpkg.com/lucide@latest/dist/umd/lucide.js';
                script.onload = function() {
                    lucide.createIcons();
                    console.log('Lucide loaded and icons created');
                };
                document.head.appendChild(script);
            }
        });

        // Retry icon initialization when page is fully loaded
        window.addEventListener('load', function() {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        });
    </script>

    <!-- Core JS Files -->
    <script src="temp/custom/js/jquery.min.js"></script>
    <script src="temp/custom/js/bootstrap.min.js"></script>
    <script src="temp/custom/js/jquery.validate.min.js"></script>
    <script src="temp/custom/js/jquery.form.js"></script>

    <?php if($settings->tido): ?>
    <script src="//code.tidio.co/<?php echo e($settings->tido); ?>.js" async></script>
    <?php endif; ?>
<?php echo $__env->make('livechat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\remedytracking\resources\views/layouts/base.blade.php ENDPATH**/ ?>