<?php $__env->startSection('title', 'Contact Us'); ?>

<?php $__env->startSection('styles'); ?>
<?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
<!-- Font Awesome Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    /* Force Font Awesome icons to always display */
    .fas, .fab, .far, .fa, .fa-icon, .form-icon, .contact-icon {
        display: inline-block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }

    /* Fix for Alpine.js hiding elements */
    [x-cloak] {
        display: block !important;
    }

    /* Ensure icon containers are properly sized */
    .icon-container {
        min-width: 24px;
        min-height: 24px;
        display: inline-flex !important;
        align-items: center;
        justify-content: center;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('content'); ?>

<!-- Page Header -->
<section class="relative bg-secondary py-16">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute inset-0 bg-secondary bg-opacity-90"></div>
        <div class="absolute w-96 h-96 -top-20 -left-20 bg-white opacity-5 rounded-full"></div>
        <div class="absolute w-96 h-96 bottom-0 right-0 bg-primary opacity-5 rounded-full"></div>
    </div>

    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col items-center">
            <h1 class="text-3xl md:text-4xl font-bold text-white mb-4">Contact Us</h1>
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="flex items-center space-x-2 text-sm text-white">
                    <li>
                        <a href="/" class="hover:text-primary transition-all">Home</a>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-chevron-right w-4 h-4 mx-1 text-white"></i>
                        <span class="text-primary">Contact Us</span>
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>
        </svg>
    </div>
</section>

<!-- Contact Information -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <!-- Section Title -->
        <div class="flex items-center mb-12">
            <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">01</div>
            <h2 class="text-3xl font-bold text-secondary">Get In Touch</h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Contact Card 1 - Address -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300">
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                    <i class="fas fa-map-marker-alt w-6 h-6 text-white contact-icon" style="display: inline-block;  !important; "></i>
                </div>
                <h3 class="text-lg font-bold text-secondary mb-2">Our Location</h3>
                <p class="text-gray-600"><?php echo e($settings->locations); ?></p>
                <a href="https://maps.google.com/?q=<?php echo e(urlencode($settings->locations)); ?>" target="_blank" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                    View on Map
                    <i class="fas fa-external-link-alt w-4 h-4 ml-1"></i>
                </a>
            </div>

            <!-- Contact Card 2 - Phone -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300">
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                    <i class="fas fa-phone-alt w-6 h-6 text-white contact-icon" style="display: inline-block !important;"></i>
                </div>
                <h3 class="text-lg font-bold text-secondary mb-2">Call Us</h3>
                <p class="text-gray-600"><?php echo e($settings->whatsapp); ?></p>
                <a href="tel:<?php echo e(preg_replace('/[^0-9+]/', '', $settings->whatsapp)); ?>" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                    Call Now
                    <i class="fas fa-chevron-right w-4 h-4 ml-1"></i>
                </a>
            </div>

            <!-- Contact Card 3 - Email -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300">
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                    <i class="fas fa-envelope w-6 h-6 text-white contact-icon" style="display: inline-block !important;"></i>
                </div>
                <h3 class="text-lg font-bold text-secondary mb-2">Email Us</h3>
                <p class="text-gray-600"><?php echo e($settings->contact_email); ?></p>
                <a href="mailto:<?php echo e($settings->contact_email); ?>" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                    Send Email
                    <i class="fas fa-chevron-right w-4 h-4 ml-1 text-white"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Contact Form & Map Section -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <!-- Section Title -->
        <div class="flex items-center mb-12">
            <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">02</div>
            <h2 class="text-3xl font-bold text-secondary">Send Us a Message</h2>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Contact Form -->
            <div class="bg-white rounded-lg shadow-lg p-8">
                <?php if(Session::has('success')): ?>
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6" role="alert">
                    <p class="font-bold">Success!</p>
                    <p><?php echo e(Session::get('success')); ?></p>
                </div>
                <?php endif; ?>

                <?php if(Session::has('error')): ?>
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
                    <p class="font-bold">Error!</p>
                    <p><?php echo e(Session::get('error')); ?></p>
                </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
                    <p class="font-bold">Please fix the following errors:</p>
                    <ul class="mt-2 list-disc list-inside">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('enquiry')); ?>" class="space-y-6"
                      x-data="{ formSubmitting: false }"
                      x-cloak
                      @submit="formSubmitting = true; setTimeout(() => { if (formSubmitting) formSubmitting = false; }, 10000)">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Full Name</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-user text-gray-400 form-icon"></i>
                                </div>
                                <input type="text" id="name" name="name" value="<?php echo e(old('name')); ?>" class="pl-10 block w-full rounded-md border-gray-300 shadow-sm focus:border-primary focus:ring focus:ring-primary focus:ring-opacity-50 py-2 px-4 border <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="John Doe" required>
                            </div>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-envelope text-gray-400 form-icon"></i>
                                </div>
                                <input type="email" id="email" name="email" value="<?php echo e(old('email')); ?>" class="pl-10 block w-full rounded-md border-gray-300 shadow-sm focus:border-primary focus:ring focus:ring-primary focus:ring-opacity-50 py-2 px-4 border <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="email@example.com" required>
                            </div>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="phone" class="block text-sm font-medium text-gray-700 mb-1">Phone Number</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-phone text-gray-400 form-icon"></i>
                                </div>
                                <input type="text" id="phone" name="phone" value="<?php echo e(old('phone')); ?>" class="pl-10 block w-full rounded-md border-gray-300 shadow-sm focus:border-primary focus:ring focus:ring-primary focus:ring-opacity-50 py-2 px-4 border <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="+1 (123) 456-7890" required>
                            </div>
                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div>
                            <label for="country" class="block text-sm font-medium text-gray-700 mb-1">Country</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-globe text-gray-400 form-icon"></i>
                                </div>
                                <input type="text" id="country" name="country" value="<?php echo e(old('country')); ?>" class="pl-10 block w-full rounded-md border-gray-300 shadow-sm focus:border-primary focus:ring focus:ring-primary focus:ring-opacity-50 py-2 px-4 border <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="United States" required>
                            </div>
                            <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div>
                        <label for="message" class="block text-sm font-medium text-gray-700 mb-1">Your Message</label>
                        <div class="relative">
                            <div class="absolute top-3 left-3 pointer-events-none">
                                <i class="fas fa-comment text-gray-400 form-icon"></i>
                            </div>
                            <textarea id="message" name="message" rows="5" class="pl-10 block w-full rounded-md border-gray-300 shadow-sm focus:border-primary focus:ring focus:ring-primary focus:ring-opacity-50 py-2 px-4 border <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="How can we help you?" required><?php echo e(old('message')); ?></textarea>
                        </div>
                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <button
                            type="submit"
                            name="contact_request"
                            class="w-full bg-primary text-white py-3 px-6 rounded-md font-medium hover:bg-opacity-90 transition-all flex items-center justify-center disabled:opacity-50 disabled:cursor-not-allowed"
                            x-bind:disabled="formSubmitting"
                        >
                            <span x-show="!formSubmitting">
                                <i class="fas fa-paper-plane mr-2"></i>
                                Send Message
                            </span>
                            <span x-show="formSubmitting" class="flex items-center">
                                <i class="fas fa-spinner fa-spin mr-2"></i>
                                Sending...
                            </span>
                        </button>
                    </div>
                </form>
            </div>

            <!-- Map -->
            <div class="bg-white rounded-lg shadow-lg overflow-hidden h-full min-h-[400px]">
                <iframe
                    width="100%"
                    height="100%"
                    style="min-height: 400px; border:0;"
                    loading="lazy"
                    allowfullscreen
                    src="https://www.google.com/maps/embed/v1/place?key=AIzaSyBFw0Qbyq9zTFTd-tUY6dZWTgaQzuU17R8&q=<?php echo e(urlencode($settings->locations)); ?>">
                </iframe>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <!-- Section Title -->
        <div class="flex items-center mb-12">
            <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">03</div>
            <h2 class="text-3xl font-bold text-secondary">Frequently Asked Questions</h2>
        </div>

        <div class="max-w-3xl mx-auto" x-data="{ activeTab: 'none', initIcons() { setTimeout(function() { document.querySelectorAll('.fa-icon').forEach(el => el.style.display = 'inline-block'); }, 100); } }" x-init="initIcons()" x-cloak>
            <!-- FAQ Item 1 -->
            <div class="mb-4">
                <button
                    @click="activeTab = (activeTab === 'faq1') ? 'none' : 'faq1'; initIcons()"
                    class="flex justify-between items-center w-full bg-gray-50 hover:bg-gray-100 p-4 rounded-lg focus:outline-none transition-all"
                    :class="{'bg-gray-100': activeTab === 'faq1'}"
                >
                    <span class="font-medium text-left text-secondary">How can I track my shipment?</span>
                    <i class="fas fa-chevron-down transform transition-transform fa-icon" style="display: inline-block !important;" :class="{'rotate-180': activeTab === 'faq1'}"></i>
                </button>
                <div
                    x-show="activeTab === 'faq1'"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    class="p-4 bg-gray-50 rounded-b-lg text-gray-600"
                >
                    <p>You can easily track your shipment by entering your tracking number in the tracking form on our homepage. Alternatively, you can contact our customer service team with your tracking number for assistance.</p>
                </div>
            </div>

            <!-- FAQ Item 2 -->
            <div class="mb-4">
                <button
                    @click="activeTab = (activeTab === 'faq2') ? 'none' : 'faq2'; initIcons()"
                    class="flex justify-between items-center w-full bg-gray-50 hover:bg-gray-100 p-4 rounded-lg focus:outline-none transition-all"
                    :class="{'bg-gray-100': activeTab === 'faq2'}"
                >
                    <span class="font-medium text-left text-secondary">What shipping services do you offer?</span>
                    <i class="fas fa-chevron-down transform transition-transform fa-icon" style="display: inline-block !important;" :class="{'rotate-180': activeTab === 'faq2'}"></i>
                </button>
                <div
                    x-show="activeTab === 'faq2'"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    class="p-4 bg-gray-50 rounded-b-lg text-gray-600"
                >
                    <p>We offer a comprehensive range of shipping services including express delivery, standard shipping, international shipping, freight forwarding, and specialized handling for fragile or oversized items. Contact us for a customized shipping solution for your specific needs.</p>
                </div>
            </div>

            <!-- FAQ Item 3 -->
            <div class="mb-4">
                <button
                    @click="activeTab = (activeTab === 'faq3') ? 'none' : 'faq3'; initIcons()"
                    class="flex justify-between items-center w-full bg-gray-50 hover:bg-gray-100 p-4 rounded-lg focus:outline-none transition-all"
                    :class="{'bg-gray-100': activeTab === 'faq3'}"
                >
                    <span class="font-medium text-left text-secondary">How do I get a shipping quote?</span>
                    <i class="fas fa-chevron-down transform transition-transform fa-icon" style="display: inline-block !important;" :class="{'rotate-180': activeTab === 'faq3'}"></i>
                </button>
                <div
                    x-show="activeTab === 'faq3'"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    class="p-4 bg-gray-50 rounded-b-lg text-gray-600"
                >
                    <p>You can request a shipping quote through our website's quote request form, by calling our customer service line, or by sending an email with details about your shipment. Be sure to include the origin and destination, package dimensions, weight, and any special handling requirements.</p>
                </div>
            </div>

            <!-- FAQ Item 4 -->
            <div class="mb-4">
                <button
                    @click="activeTab = (activeTab === 'faq4') ? 'none' : 'faq4'; initIcons()"
                    class="flex justify-between items-center w-full bg-gray-50 hover:bg-gray-100 p-4 rounded-lg focus:outline-none transition-all"
                    :class="{'bg-gray-100': activeTab === 'faq4'}"
                >
                    <span class="font-medium text-left text-secondary">What are your delivery times?</span>
                    <i class="fas fa-chevron-down transform transition-transform fa-icon" style="display: inline-block !important;" :class="{'rotate-180': activeTab === 'faq4'}"></i>
                </button>
                <div
                    x-show="activeTab === 'faq4'"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    class="p-4 bg-gray-50 rounded-b-lg text-gray-600"
                >
                    <p>Delivery times vary based on the service selected and destination. Our express services typically deliver within 1-2 business days domestically and 3-5 business days internationally. Standard shipping usually takes 3-5 business days domestically and 7-14 business days internationally.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="py-12 bg-secondary relative">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="mb-6 md:mb-0">
                <h2 class="text-2xl md:text-3xl font-bold text-white">Ready to Ship Your Package?</h2>
                <p class="text-white text-opacity-90 mt-2">Get in touch today for a free shipping quote!</p>
            </div>
            <div class="flex flex-wrap gap-4">
                <a href="request-quote" class="bg-primary text-white hover:bg-opacity-90 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i class="fas fa-quote-right mr-2"></i>
                    Request a Quote
                </a>
            </div>
        </div>
    </div>

    <!-- Wave Pattern Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 48" class="text-white fill-current">
            <path d="M0,0L48,8C96,16,192,32,288,32C384,32,480,16,576,16C672,16,768,32,864,37.3C960,43,1056,37,1152,32C1248,27,1344,21,1392,18.7L1440,16L1440,48L1392,48C1344,48,1248,48,1152,48C1056,48,960,48,864,48C768,48,672,48,576,48C480,48,384,48,288,48C192,48,96,48,48,48L0,48Z"></path>
        </svg>
    </div>
</section>

<?php $__env->startPush('scripts'); ?>
<script>
    // Simple and reliable form submission handling
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('form[action*="enquiry"]');
        if (form) {
            let isSubmitting = false;

            form.addEventListener('submit', function(e) {
                // Prevent double submission
                if (isSubmitting) {
                    e.preventDefault();
                    return false;
                }

                isSubmitting = true;
                const submitButton = form.querySelector('button[type="submit"]');

                if (submitButton) {
                    submitButton.disabled = true;
                }

                // Safety reset after 15 seconds
                setTimeout(() => {
                    isSubmitting = false;
                    if (submitButton) {
                        submitButton.disabled = false;
                    }
                }, 15000);
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sbrbot/trackmate.sbrbot.trading/resources/views/home/contact.blade.php ENDPATH**/ ?>