<?php $__env->startComponent('mail::message'); ?>
# Quote Request Received - Thank You!

Dear <?php echo e($quoteRequest->full_name); ?>,

Thank you for your interest in our shipping services! We have received your quote request and our team is reviewing it.

**Your Reference Number:** <?php echo e($quoteRequest->reference_number); ?>


## Your Request Summary
- **Freight Type:** <?php echo e($quoteRequest->freight_type); ?>

- **From:** <?php echo e($quoteRequest->departure_country); ?>

- **To:** <?php echo e($quoteRequest->recipient_country); ?>

- **Priority:** <?php echo e(ucfirst($quoteRequest->priority)); ?> shipping
- **Insurance:** <?php echo e($quoteRequest->insurance ? 'Included' : 'Not requested'); ?>


## What Happens Next?
1. Our logistics experts will review your requirements
2. We'll prepare a detailed quote with competitive pricing
3. You'll receive your personalized quote within **24 hours**
4. We may contact you if we need additional information

<?php $__env->startComponent('mail::button', ['url' => url('/track-order')]); ?>
Track Your Request
<?php echo $__env->renderComponent(); ?>

If you have any questions or need immediate assistance, please don't hesitate to contact us.

**Contact Information:**
- Email: <?php echo e($settings->email ?? 'support@company.com'); ?>

- Phone: <?php echo e($settings->phone ?? 'N/A'); ?>


Thanks for choosing <?php echo e($settings->site_title); ?>!<br>
Customer Service Team
<?php echo $__env->renderComponent(); ?>
<?php /**PATH C:\xampp\htdocs\remedytracking\resources\views/emails/quote-request-confirmation.blade.php ENDPATH**/ ?>