<?php $__env->startSection('title', $settings->site_title); ?>


<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('content'); ?>

  <body  style="background-color:teal;"  onload="window.print();">



<div class="wrapper" id="background">
  <p id="bg-text">Copia Certificada Fiel</p>

  <!-- Contenido principal -->
  <section class="invoice">
    <!-- fila del título -->
    <div class="row">
      <div class="col-xs-12">
        <h2 class="page-header">
          <span>
            <img src="<?php echo e(asset('storage/app/public/'.$settings->logo)); ?>" height="45" width='130'>

            <img class="pull-right" src="<?php echo e(asset('temp/custom/banner.png')); ?>" alt="" height="185"/>

            <h3 style="color:red;">
              <strong>Número de Seguimiento: <?php echo e($user->trackingnumber); ?></strong>
            </h3>
          </span>
        </h2>
      </div><!-- /.col -->
    </div>

    <div class="row">
      <div class="col-xs-12">
        <h2 class="page-header">
          <center>
            <strong style="color:green;">
              <?php echo e($settings->site_name); ?> Compañía Logística<br>
              Dirección: Barcelona, ESPAÑA<br>
              Correo electrónico: <?php echo e($settings->contact_email); ?><br>
              Sitio web de la empresa: <?php echo e($settings->site_address); ?>

            </strong>
          </center>
        </h2>
      </div><!-- /.col -->
    </div>

    <!-- fila de información -->
    <div class="row invoice-info">
      <div class="col-sm-4 invoice-col">
        <strong style="color:blue;">DE (REMITENTE)</strong>
        <address>
          <h3><strong style="color:green;"><?php echo e($user->sname); ?></strong></h3>
          <b>Dirección:</b> <?php echo e($user->saddress); ?><br/>
          <b>Oficina de Origen:</b> <?php echo e($user->take_off_point); ?>

        </address>
      </div><!-- /.col -->

      <div class="col-sm-4 invoice-col">
        <strong style="color:blue;">A (DESTINATARIO)</strong>
        <address>
          <h3><strong style="color:green;"><?php echo e($user->name); ?></strong></h3>
          <b>Teléfono:</b> <?php echo e($user->phone); ?><br/>
          <b>Dirección:</b> <?php echo e($user->address); ?><br/>
          <b>Oficina de Destino:</b> <?php echo e($user->final_destination); ?>

        </address>
      </div><!-- /.col -->

      <div class="col-sm-4 invoice-col">
        <table>
          <tr>
            <td>
              <center>
                <img src="https://barcode.tec-it.com/barcode.ashx?data=<?php echo e($user->trackingnumber); ?>&code=Code128" alt="<?php echo e($user->trackingnumber); ?>"><br>
              </center>
            </td>
          </tr>
        </table>
        <br/>
        <b>ID del Pedido:</b>&nbsp;&nbsp;<?php echo e($user->id); ?> <br/>
        <b>Modo de Reserva:</b> <small class="label label-danger"><i class="fa fa-money"></i>&nbsp;&nbsp;Por Pagar</small><br/>
        <b>Costo de Envío:</b>&nbsp;<?php echo e($settings->s_currency); ?>&nbsp;<?php echo e($user->cost); ?><br/>
        <b>Número de Seguimiento:</b>&nbsp;&nbsp;<?php echo e($user->trackingnumber); ?> <br/>
      </div><!-- /.col -->
    </div><!-- /.row -->

    <!-- fila de la tabla -->
    <div class="row">
      <div class="col-xs-12 table-responsive">
        <table class="table table-striped">
          <thead>
            <tr>
              <th>Cant.</th>
              <th>Producto</th>
              <th>Estado</th>
              <th>Descripción</th>
              <th>Costo de Envío</th>
              <th>Costo de Despacho</th>
              <th>Costo Total</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td><?php echo e($user->qty); ?></td>
              <td>Paquete</td>
              <td><small class="label label-success"><?php echo e($user->status); ?> </small></td>
              <td><?php echo e($user->description); ?> </td>
              <td><?php echo e($settings->s_currency); ?>&nbsp;<?php echo e($user->cost); ?> </td>
              <td><?php echo e($settings->s_currency); ?>&nbsp;<?php echo e($user->clearance_cost); ?></td>
              <td><?php echo e($settings->s_currency); ?>&nbsp;<?php echo e($user->clearance_cost+$user->cost); ?></td>
            </tr>
          </tbody>
        </table>
      </div><!-- /.col -->
    </div><!-- /.row -->
    <br><br>

    <div class="row">
      <!-- columna de pagos aceptados -->
      <div class="col-xs-4">
        <p class="lead"><strong>Métodos de Pago:</strong></p>
        <img src="<?php echo e(asset('temp/securepayment.png')); ?>" alt="Métodos de pago" />
        <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
          Para su comodidad, en <?php echo e($settings->site_name); ?> ofrecemos varios métodos de pago confiables, rápidos y seguros.
        </p>
      </div>

      <div class="col-xs-4">
        <p class="lead"><strong>Sello Oficial/<?php echo e(\Carbon\Carbon::parse($user->created_at)->toDayDateTimeString()); ?></strong></p>
        <img src="<?php echo e(asset('temp/stamp1.png')); ?>" alt="" height="100" />
      </div>

      <div class="col-xs-4">
        <p class="lead">Impuesto de Timbre:</p>
        <img class='text-center' src="<?php echo e(asset('temp/stamp2.png')); ?>" alt="" height="100"/>
      </div>

      <!-- /.col -->
      <div class="col-xs-6">
        <p class="lead"><strong>Monto a Pagar</strong></p>
        <div class="table-responsive">
          <table class="table">
            <tr>
              <th style="width:50%">COSTO DE ENVÍO:</th>
              <th>COSTO DE DESPACHO:</th>
              <th>MONTO TOTAL:</th>
            </tr>
            <tr>
              <td><?php echo e($settings->s_currency); ?>&nbsp;<?php echo e($user->cost); ?></td>
              <td><?php echo e($settings->s_currency); ?>&nbsp;<?php echo e($user->clearance_cost); ?></td>
              <td><?php echo e($settings->s_currency); ?>&nbsp;<?php echo e($user->clearance_cost+$user->cost); ?></td>
            </tr>
          </table>
        </div>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </section><!-- /.content -->
</div><!-- ./wrapper -->


    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.invoice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/acefinca/acirfa-es.sbs/resources/views/home/printinvoice.blade.php ENDPATH**/ ?>