@extends('layouts.base')
@inject('content', 'App\Http\Controllers\FrontController')

@section('styles')
@parent
<!-- Font Awesome Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integr                        <div class="flex justify-end mt-8">
                        <button
                            @click="if(validateStep1()) currentStep = 2"
                            class="bg-primary hover:bg-secondary text-white font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center"
                        >
                            Next Step
                            <i class="fas fa-arrow-right ml-2 text-white"></i>
                        </button>
                    </div>12-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    /* Force Font Awesome icons to always display */
    .fas, .fab, .far, .fa, .fa-icon, .quote-icon {
        display: inline-block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }

    /* Fix for Alpine.js hiding elements before initialization */
    [x-cloak] {
        display: none !important;
    }

    /* Custom input focus styles */
    .form-input:focus, .form-select:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(255, 77, 0, 0.2);
    }

    /* Custom checkbox style */
    .custom-checkbox:checked {
        background-color: var(--primary-color);
        border-color: var(--primary-color);
    }

    /* Track step connections */
    .step-line {
        position: absolute;
        left: 50%;
        width: 2px;
        height: 100%;
        background-color: #e5e7eb;
        z-index: -1;
    }

    .step-active .step-line {
        background-color: var(--primary-color);
    }

    /* Loading indicator animation */
    @keyframes pulse {
        0%, 100% {
            opacity: 1;
        }
        50% {
            opacity: 0.5;
        }
    }

    .animate-pulse {
        animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
    }

    /* Ensure icon visibility against similar backgrounds */
    .bg-primary .text-primary,
    .bg-primary-light .text-primary,
    [class*="bg-primary"] [class*="text-primary"] {
        color: white !important;
    }
</style>
@endsection

@section('content')
<!-- Page Header -->
<!--<section class="relative bg-secondary py-16">-->
<!--    <div class="absolute inset-0 overflow-hidden">-->
<!--        <div class="absolute inset-0 bg-secondary bg-opacity-90"></div>-->
<!--        <div class="absolute w-96 h-96 -top-20 -left-20 bg-white opacity-5 rounded-full"></div>-->
<!--        <div class="absolute w-96 h-96 bottom-0 right-0 bg-primary opacity-5 rounded-full"></div>-->
<!--    </div>-->

<!--    <div class="container mx-auto px-4 relative z-10">-->
<!--        <div class="flex flex-col items-center">-->
<!--            <h1 class="text-3xl md:text-4xl font-bold text-white mb-4">Request a Quote</h1>-->
<!--            <nav class="flex" aria-label="Breadcrumb">-->
<!--                <ol class="flex items-center space-x-2 text-sm text-white">-->
<!--                    <li>-->
<!--                        <a href="/" class="hover:text-primary transition-all">Home</a>-->
<!--                    </li>-->
<!--                    <li class="flex items-center">-->
<!--                        <i class="fas fa-chevron-right w-4 h-4 mx-1 text-white"></i>-->
<!--                        <span class="text-white">Request a Quote</span>-->
<!--                    </li>-->
<!--                </ol>-->
<!--            </nav>-->
<!--        </div>-->
<!--    </div>-->

    <!-- Wave Bottom -->
<!--    <div class="absolute bottom-0 left-0 right-0">-->
<!--        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">-->
<!--            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>-->
<!--        </svg>-->
<!--    </div>-->
<!--</section>-->
<section class="relative bg-secondary py-16">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute inset-0 bg-secondary bg-opacity-90"></div>
        <div class="absolute w-96 h-96 -top-20 -left-20 bg-white opacity-5 rounded-full"></div>
        <div class="absolute w-96 h-96 bottom-0 right-0 bg-primary opacity-5 rounded-full"></div>
    </div>

    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col items-center">
            <h1 class="text-3xl md:text-4xl font-bold text-white mb-4">Solicitar Cotización</h1>
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="flex items-center space-x-2 text-sm text-white">
                    <li>
                        <a href="/" class="hover:text-primary transition-all">Inicio</a>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-chevron-right w-4 h-4 mx-1 text-white"></i>
                        <span class="text-white">Solicitar Cotización</span>
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>
        </svg>
    </div>
</section>


<!-- Quote Request Form Section -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-5xl mx-auto">
            <!-- Section Title -->
           <div class="text-center mb-12">
    <h2 class="text-3xl font-bold text-secondary mb-4">Obtén tu Cotización de Envío</h2>
    <p class="text-gray-600 max-w-2xl mx-auto">
        Complete el formulario a continuación para recibir una cotización de envío personalizada según sus necesidades específicas. Nuestro equipo le proporcionará tarifas competitivas y soluciones logísticas eficientes.
    </p>
</div>


            <div class="bg-white rounded-lg overflow-hidden shadow-xl" x-cloak x-data="{
                currentStep: 1,
                isSubmitting: false,
                submitError: '',
                submitSuccess: false,
                referenceNumber: '',
                formData: {
                    freightType: '',
                    email: '',
                    departureCountry: '',
                    weight: '',
                    recipientCountry: '',
                    expectedDeliveryDate: '',
                    fullName: '',
                    phone: '',
                    companyName: '',
                    description: '',
                    dimensions: '',
                    priority: 'standard',
                    insurance: false
                },
                async submitForm() {
                    this.isSubmitting = true;
                    this.submitError = '';

                    try {
                        const formData = new FormData();
                        Object.keys(this.formData).forEach(key => {
                            if (key === 'insurance') {
                                formData.append(key, this.formData[key] ? '1' : '0');
                            } else {
                                formData.append(key, this.formData[key] || '');
                            }
                        });

                        // Convert camelCase keys to snake_case for Laravel
                        formData.set('freight_type', this.formData.freightType);
                        formData.set('departure_country', this.formData.departureCountry);
                        formData.set('recipient_country', this.formData.recipientCountry);
                        formData.set('expected_delivery_date', this.formData.expectedDeliveryDate);
                        formData.set('full_name', this.formData.fullName);
                        formData.set('company_name', this.formData.companyName);

                        formData.append('_token', '{{ csrf_token() }}');

                        const response = await fetch('{{ route('submit-quote') }}', {
                            method: 'POST',
                            body: formData,
                            headers: {
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        });

                        const result = await response.json();

                        if (result.success) {
                            this.referenceNumber = result.reference_number;
                            this.submitSuccess = true;
                            this.currentStep = 4;
                        } else {
                            this.submitError = result.message || 'Please check your form and try again.';
                            if (result.errors) {
                                // Handle validation errors
                                const firstError = Object.values(result.errors)[0];
                                this.submitError = Array.isArray(firstError) ? firstError[0] : firstError;
                            }
                        }
                    } catch (error) {
                        console.error('Form submission error:', error);
                        this.submitError = 'Network error. Please check your connection and try again.';
                    } finally {
                        this.isSubmitting = false;
                    }
                },
                validateStep1() {
                    if (!this.formData.freightType || !this.formData.email || !this.formData.departureCountry) {
                        alert('Please fill out all required fields marked with *');
                        return false;
                    }
                    if (!this.validateEmail(this.formData.email)) {
                        alert('Please enter a valid email address');
                        return false;
                    }
                    return true;
                },
                validateStep2() {
                    if (!this.formData.recipientCountry || !this.formData.fullName) {
                        alert('Please fill out all required fields marked with *');
                        return false;
                    }
                    return true;
                },
                validateEmail(email) {
                    const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                    return re.test(email);
                }
            }">
                
                <!-- Progress Indicator -->
                <div class="bg-gray-50 py-4 px-6 border-b border-gray-200">
                    <div class="flex justify-between items-center">
                        <div class="flex items-center">
                            <span class="text-lg font-medium text-secondary">Request a Quote</span>
                            <span class="ml-2 bg-primary text-white text-xs font-bold px-2 py-1 rounded-full">Free</span>
                        </div>
                        <div class="hidden sm:flex items-center space-x-4">
                            <div class="flex items-center" :class="{'text-secondary': currentStep >= 1, 'text-gray-400': currentStep < 1}">
                                <span class="w-8 h-8 rounded-full flex items-center justify-center"
                                      :class="{'bg-primary text-white': currentStep >= 1, 'bg-gray-200': currentStep < 1}">1</span>
                                <span class="ml-2 font-medium">Shipment</span>
                            </div>
                            <div class="w-8 h-1" :class="{'bg-primary': currentStep >= 2, 'bg-gray-200': currentStep < 2}"></div>
                            <div class="flex items-center" :class="{'text-secondary': currentStep >= 2, 'text-gray-400': currentStep < 2}">
                                <span class="w-8 h-8 rounded-full flex items-center justify-center"
                                      :class="{'bg-primary text-white': currentStep >= 2, 'bg-gray-200': currentStep < 2}">2</span>
                                <span class="ml-2 font-medium">Details</span>
                            </div>
                            <div class="w-8 h-1" :class="{'bg-primary': currentStep >= 3, 'bg-gray-200': currentStep < 3}"></div>
                            <div class="flex items-center" :class="{'text-secondary': currentStep >= 3, 'text-gray-400': currentStep < 3}">
                                <span class="w-8 h-8 rounded-full flex items-center justify-center"
                                      :class="{'bg-primary text-white': currentStep >= 3, 'bg-gray-200': currentStep < 3}">3</span>
                                <span class="ml-2 font-medium">Confirm</span>
                            </div>
                        </div>
                    </div>
                </div>
                

                <!-- Form Step 1: Shipment Basics -->
                <!--<div x-show="currentStep === 1" class="p-6">-->
                <!--    <h3 class="text-xl font-semibold text-secondary mb-6">Shipment Information</h3>-->

                <!--    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">-->
                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="freight-type">-->
                <!--                Freight Type <span class="text-red-500">*</span>-->
                <!--            </label>-->
                <!--            <div class="relative">-->
                <!--                <select-->
                <!--                    x-model="formData.freightType"-->
                <!--                    class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-select"-->
                <!--                    id="freight-type"-->
                <!--                    required-->
                <!--                >-->
                <!--                    <option value="">-- Select Type</option>-->
                <!--                    <option value="Air Freight">Air Freight</option>-->
                <!--                    <option value="Ocean Freight">Ocean Freight</option>-->
                <!--                    <option value="Road Freight">Road Freight</option>-->
                <!--                </select>-->
                <!--                <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-700">-->
                <!--                    <i class="fas fa-chevron-down"></i>-->
                <!--                </div>-->
                <!--            </div>-->
                <!--            <p class="text-sm text-gray-500 mt-1">Select the type of shipping service you need</p>-->
                <!--        </div>-->

                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="email">-->
                <!--                Email Address <span class="text-red-500">*</span>-->
                <!--            </label>-->
                <!--            <input-->
                <!--                x-model="formData.email"-->
                <!--                type="email"-->
                <!--                id="email"-->
                <!--                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--                placeholder="your@email.com"-->
                <!--                required-->
                <!--            >-->
                <!--            <p x-show="formData.email && !validateEmail(formData.email)" class="text-sm text-red-500 mt-1">-->
                <!--                Please enter a valid email address-->
                <!--            </p>-->
                <!--        </div>-->

                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="departure">-->
                <!--                Departure Country <span class="text-red-500">*</span>-->
                <!--            </label>-->
                <!--            <input-->
                <!--                x-model="formData.departureCountry"-->
                <!--                type="text"-->
                <!--                id="departure"-->
                <!--                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--                placeholder="Country of Departure"-->
                <!--                required-->
                <!--            >-->
                <!--        </div>-->

                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="weight">-->
                <!--                Total Weight (KG)-->
                <!--            </label>-->
                <!--            <input-->
                <!--                x-model="formData.weight"-->
                <!--                type="text"-->
                <!--                id="weight"-->
                <!--                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--                placeholder="Estimated total weight"-->
                <!--            >-->
                <!--            <p class="text-sm text-gray-500 mt-1">If unknown, you can leave this blank</p>-->
                <!--        </div>-->
                <!--    </div>-->

                <!--    <div class="flex justify-end mt-8">-->
                <!--        <button-->
                <!--            @click="if(validateStep1()) currentStep = 2"-->
                <!--            class="bg-primary hover:bg-secondary text-white font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center"-->
                <!--        >-->
                <!--            Next Step-->
                <!--            <i class="fas fa-arrow-right ml-2"></i>-->
                <!--        </button>-->
                <!--    </div>-->
                <!--</div>-->

                <!-- Form Step 2: Additional Details -->
                <!--<div x-show="currentStep === 2" x-cloak class="p-6">-->
                <!--    <h3 class="text-xl font-semibold text-secondary mb-6">Shipment Details</h3>-->

                <!--    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">-->
                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="recipient-country">-->
                <!--                Recipient's Country <span class="text-red-500">*</span>-->
                <!--            </label>-->
                <!--            <input-->
                <!--                x-model="formData.recipientCountry"-->
                <!--                type="text"-->
                <!--                id="recipient-country"-->
                <!--                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--                placeholder="Country of destination"-->
                <!--                required-->
                <!--            >-->
                <!--        </div>-->

                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="expected-date">-->
                <!--                Expected Delivery Date-->
                <!--            </label>-->
                <!--            <input-->
                <!--                x-model="formData.expectedDeliveryDate"-->
                <!--                type="date"-->
                <!--                id="expected-date"-->
                <!--                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--            >-->
                <!--        </div>-->

                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="fullname">-->
                <!--                Full Name <span class="text-red-500">*</span>-->
                <!--            </label>-->
                <!--            <input-->
                <!--                x-model="formData.fullName"-->
                <!--                type="text"-->
                <!--                id="fullname"-->
                <!--                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--                placeholder="Your full name"-->
                <!--                required-->
                <!--            >-->
                <!--        </div>-->

                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="phone">-->
                <!--                Phone Number-->
                <!--            </label>-->
                <!--            <input-->
                <!--                x-model="formData.phone"-->
                <!--                type="tel"-->
                <!--                id="phone"-->
                <!--                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--                placeholder="Your contact number"-->
                <!--            >-->
                <!--        </div>-->

                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="company">-->
                <!--                Company Name-->
                <!--            </label>-->
                <!--            <input-->
                <!--                x-model="formData.companyName"-->
                <!--                type="text"-->
                <!--                id="company"-->
                <!--                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--                placeholder="Your company name (if applicable)"-->
                <!--            >-->
                <!--        </div>-->

                <!--        <div>-->
                <!--            <label class="block text-gray-700 font-medium mb-2" for="dimensions">-->
                <!--                Package Dimensions-->
                <!--            </label>-->
                <!--            <input-->
                <!--                x-model="formData.dimensions"-->
                <!--                type="text"-->
                <!--                id="dimensions"-->
                <!--                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--                placeholder="e.g., 30cm x 40cm x 20cm"-->
                <!--            >-->
                <!--        </div>-->
                <!--    </div>-->

                <!--    <div class="mt-6">-->
                <!--        <label class="block text-gray-700 font-medium mb-2" for="description">-->
                <!--            Shipment Description-->
                <!--        </label>-->
                <!--        <textarea-->
                <!--            x-model="formData.description"-->
                <!--            id="description"-->
                <!--            rows="4"-->
                <!--            class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"-->
                <!--            placeholder="Describe the contents of your shipment"-->
                <!--        ></textarea>-->
                <!--    </div>-->

                <!--    <div class="mt-6">-->
                <!--        <p class="block text-gray-700 font-medium mb-3">-->
                <!--            Shipping Priority-->
                <!--        </p>-->
                <!--        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">-->
                <!--            <div-->
                <!--                @click="formData.priority = 'economy'"-->
                <!--                class="border rounded-lg p-4 cursor-pointer transition-all duration-300"-->
                <!--                :class="formData.priority === 'economy' ? 'border-primary bg-primary bg-opacity-5' : 'border-gray-200 hover:bg-gray-50'"-->
                <!--            >-->
                <!--                <div class="flex items-center mb-2">-->
                <!--                    <i class="fas fa-truck-loading text-2xl mr-3 text-gray-400" :class="formData.priority === 'economy' ? 'text-secondary' : 'text-gray-400'"></i>-->
                <!--                    <h4 class="font-medium" :class="formData.priority === 'economy' ? 'text-secondary' : 'text-secondary'">Economy</h4>-->
                <!--                </div>-->
                <!--                <p class="text-sm text-gray-500">Budget-friendly option with standard delivery times</p>-->
                <!--            </div>-->

                <!--            <div-->
                <!--                @click="formData.priority = 'standard'"-->
                <!--                class="border rounded-lg p-4 cursor-pointer transition-all duration-300"-->
                <!--                :class="formData.priority === 'standard' ? 'border-primary bg-primary bg-opacity-5' : 'border-gray-200 hover:bg-gray-50'"-->
                <!--            >-->
                <!--                <div class="flex items-center mb-2">-->
                <!--                    <i class="fas fa-shipping-fast text-2xl mr-3 text-gray-400" :class="formData.priority === 'standard' ? 'text-secondary' : 'text-gray-400'"></i>-->
                <!--                    <h4 class="font-medium" :class="formData.priority === 'standard' ? 'text-secondary' : 'text-secondary'">Standard</h4>-->
                <!--                </div>-->
                <!--                <p class="text-sm text-gray-500">Balanced option between cost and delivery speed</p>-->
                <!--            </div>-->

                <!--            <div-->
                <!--                @click="formData.priority = 'express'"-->
                <!--                class="border rounded-lg p-4 cursor-pointer transition-all duration-300"-->
                <!--                :class="formData.priority === 'express' ? 'border-primary bg-primary bg-opacity-5' : 'border-gray-200 hover:bg-gray-50'"-->
                <!--            >-->
                <!--                <div class="flex items-center mb-2">-->
                <!--                    <i class="fas fa-rocket text-2xl mr-3 text-gray-400" :class="formData.priority === 'express' ? 'text-secondary' : 'text-gray-400'"></i>-->
                <!--                    <h4 class="font-medium" :class="formData.priority === 'express' ? 'text-secondary' : 'text-secondary'">Express</h4>-->
                <!--                </div>-->
                <!--                <p class="text-sm text-gray-500">Premium option for fastest possible delivery</p>-->
                <!--            </div>-->
                <!--        </div>-->
                <!--    </div>-->

                <!--    <div class="mt-6">-->
                <!--        <label class="flex items-center">-->
                <!--            <input-->
                <!--                x-model="formData.insurance"-->
                <!--                type="checkbox"-->
                <!--                class="form-checkbox rounded text-primary focus:ring-primary h-5 w-5 custom-checkbox"-->
                <!--            >-->
                <!--            <span class="ml-2 text-gray-700">Include shipment insurance (recommended)</span>-->
                <!--        </label>-->
                <!--    </div>-->

                <!--    <div class="flex justify-between mt-8">-->
                <!--        <button-->
                <!--            @click="currentStep = 1"-->
                <!--            class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center"-->
                <!--        >-->
                <!--            <i class="fas fa-arrow-left mr-2 text-gray-600"></i>-->
                <!--            Previous-->
                <!--        </button>-->

                <!--        <button-->
                <!--            @click="if(validateStep2()) currentStep = 3"-->
                <!--            class="bg-primary hover:bg-secondary text-white font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center"-->
                <!--        >-->
                <!--            Review Quote-->
                <!--            <i class="fas fa-arrow-right ml-2 text-white"></i>-->
                <!--        </button>-->
                <!--    </div>-->
                <!--</div>-->

                <!-- Form Step 3: Review and Submit -->
                <!--<div x-show="currentStep === 3" x-cloak class="p-6">-->
                <!--    <h3 class="text-xl font-semibold text-secondary mb-6">Review Your Quote Request</h3>-->

                <!--    <div class="bg-gray-50 rounded-lg p-6 mb-6">-->
                <!--        <div class="grid grid-cols-1 md:grid-cols-2 gap-y-4">-->
                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Freight Type</p>-->
                <!--                <p class="font-medium" x-text="formData.freightType || 'Not specified'"></p>-->
                <!--            </div>-->

                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Email Address</p>-->
                <!--                <p class="font-medium" x-text="formData.email || 'Not specified'"></p>-->
                <!--            </div>-->

                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Full Name</p>-->
                <!--                <p class="font-medium" x-text="formData.fullName || 'Not specified'"></p>-->
                <!--            </div>-->

                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Phone Number</p>-->
                <!--                <p class="font-medium" x-text="formData.phone || 'Not specified'"></p>-->
                <!--            </div>-->

                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Departure Country</p>-->
                <!--                <p class="font-medium" x-text="formData.departureCountry || 'Not specified'"></p>-->
                <!--            </div>-->

                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Recipient's Country</p>-->
                <!--                <p class="font-medium" x-text="formData.recipientCountry || 'Not specified'"></p>-->
                <!--            </div>-->

                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Total Weight</p>-->
                <!--                <p class="font-medium" x-text="formData.weight ? formData.weight + ' KG' : 'Not specified'"></p>-->
                <!--            </div>-->

                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Expected Delivery Date</p>-->
                <!--                <p class="font-medium" x-text="formData.expectedDeliveryDate || 'Not specified'"></p>-->
                <!--            </div>-->

                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Shipping Priority</p>-->
                <!--                <p class="font-medium" x-text="formData.priority ? formData.priority.charAt(0).toUpperCase() + formData.priority.slice(1) : 'Standard'"></p>-->
                <!--            </div>-->

                <!--            <div>-->
                <!--                <p class="text-gray-500 text-sm">Insurance</p>-->
                <!--                <p class="font-medium" x-text="formData.insurance ? 'Yes' : 'No'"></p>-->
                <!--            </div>-->
                <!--        </div>-->

                <!--        <div class="mt-6" x-show="formData.description">-->
                <!--            <p class="text-gray-500 text-sm">Shipment Description</p>-->
                <!--            <p class="font-medium" x-text="formData.description"></p>-->
                <!--        </div>-->
                <!--    </div>-->

                <!--    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-6">-->
                <!--        <div class="flex">-->
                <!--            <div class="flex-shrink-0">-->
                <!--                <i class="fas fa-info-circle text-blue-500"></i>-->
                <!--            </div>-->
                <!--            <div class="ml-3">-->
                <!--                <p class="text-sm text-blue-700">-->
                <!--                    By submitting this form, you'll receive a detailed quote from our team within 24 hours. We may contact you for additional information if needed.-->
                <!--                </p>-->
                <!--            </div>-->
                <!--        </div>-->
                <!--    </div>-->

                    <!-- Error Message -->
                <!--    <div x-show="submitError" x-cloak class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">-->
                <!--        <div class="flex">-->
                <!--            <div class="flex-shrink-0">-->
                <!--                <i class="fas fa-exclamation-circle text-red-500"></i>-->
                <!--            </div>-->
                <!--            <div class="ml-3">-->
                <!--                <p class="text-sm text-red-700" x-text="submitError"></p>-->
                <!--            </div>-->
                <!--        </div>-->
                <!--    </div>-->

                <!--    <div class="flex justify-between mt-8">-->
                <!--        <button-->
                <!--            @click="currentStep = 2"-->
                <!--            :disabled="isSubmitting"-->
                <!--            class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center disabled:opacity-50 disabled:cursor-not-allowed"-->
                <!--        >-->
                <!--            <i class="fas fa-arrow-left mr-2 text-gray-600"></i>-->
                <!--            Edit Details-->
                <!--        </button>-->

                <!--        <button-->
                <!--            @click="submitForm()"-->
                <!--            :disabled="isSubmitting"-->
                <!--            class="bg-primary hover:bg-secondary text-white font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center disabled:opacity-50 disabled:cursor-not-allowed"-->
                <!--        >-->
                <!--            <span x-show="!isSubmitting">Submit Request</span>-->
                <!--            <span x-show="isSubmitting" x-cloak class="flex items-center">-->
                <!--                <i class="fas fa-spinner animate-spin mr-2"></i>-->
                <!--                Submitting...-->
                <!--            </span>-->
                <!--            <i x-show="!isSubmitting" class="fas fa-paper-plane ml-2 text-white"></i>-->
                <!--        </button>-->
                <!--    </div>-->
                <!--</div>-->

                <!-- Form Step 4: Confirmation -->
                <!--<div x-show="currentStep === 4" x-cloak class="p-6">-->
                <!--    <div class="text-center py-8">-->
                <!--        <div class="bg-green-100 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-6">-->
                <!--            <i class="fas fa-check-circle text-green-500 text-4xl"></i>-->
                <!--        </div>-->
                <!--        <h3 class="text-2xl font-bold text-secondary mb-2">Quote Request Submitted!</h3>-->
                <!--        <div x-show="referenceNumber" x-cloak class="bg-blue-50 border border-blue-200 rounded-lg p-3 mb-4 mx-auto max-w-sm">-->
                <!--            <p class="text-sm text-blue-600 font-medium">Your Reference Number:</p>-->
                <!--            <p class="text-lg font-bold text-blue-800" x-text="referenceNumber"></p>-->
                <!--        </div>-->
                <!--        <p class="text-gray-600 mb-8 max-w-md mx-auto">-->
                <!--            Thank you for your request. Our team will review your information and send you a detailed quote within 24 hours.-->
                <!--        </p>-->
                <!--        <div>-->
                <!--            <a href="/" class="bg-primary hover:bg-secondary text-white font-medium py-3 px-6 rounded-lg transition duration-300 inline-block">-->
                <!--                Return to Homepage-->
                <!--            </a>-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
                
                <!-- Form Step 1: Shipment Basics -->
<div x-show="currentStep === 1" class="p-6">
    <h3 class="text-xl font-semibold text-secondary mb-6">Información del Envío</h3>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label class="block text-gray-700 font-medium mb-2" for="freight-type">
                Tipo de Flete <span class="text-red-500">*</span>
            </label>
            <div class="relative">
                <select
                    x-model="formData.freightType"
                    class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-select"
                    id="freight-type"
                    required
                >
                    <option value="">-- Seleccione Tipo</option>
                    <option value="Air Freight">Flete Aéreo</option>
                    <option value="Ocean Freight">Flete Marítimo</option>
                    <option value="Road Freight">Flete Terrestre</option>
                </select>
                <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-700">
                    <i class="fas fa-chevron-down"></i>
                </div>
            </div>
            <p class="text-sm text-gray-500 mt-1">Seleccione el tipo de servicio de envío que necesita</p>
        </div>

        <div>
            <label class="block text-gray-700 font-medium mb-2" for="email">
                Correo Electrónico <span class="text-red-500">*</span>
            </label>
            <input
                x-model="formData.email"
                type="email"
                id="email"
                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
                placeholder="tu@correo.com"
                required
            >
            <p x-show="formData.email && !validateEmail(formData.email)" class="text-sm text-red-500 mt-1">
                Por favor, ingrese una dirección de correo válida
            </p>
        </div>

        <div>
            <label class="block text-gray-700 font-medium mb-2" for="departure">
                País de Salida <span class="text-red-500">*</span>
            </label>
            <input
                x-model="formData.departureCountry"
                type="text"
                id="departure"
                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
                placeholder="País de Salida"
                required
            >
        </div>

        <div>
            <label class="block text-gray-700 font-medium mb-2" for="weight">
                Peso Total (KG)
            </label>
            <input
                x-model="formData.weight"
                type="text"
                id="weight"
                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
                placeholder="Peso total estimado"
            >
            <p class="text-sm text-gray-500 mt-1">Si no lo sabe, puede dejarlo en blanco</p>
        </div>
    </div>

    <div class="flex justify-end mt-8">
        <button
            @click="if(validateStep1()) currentStep = 2"
            class="bg-primary hover:bg-secondary text-white font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center"
        >
            Siguiente Paso
            <i class="fas fa-arrow-right ml-2"></i>
        </button>
    </div>
</div>

<!-- Form Step 2: Additional Details -->
<div x-show="currentStep === 2" x-cloak class="p-6">
    <h3 class="text-xl font-semibold text-secondary mb-6">Detalles del Envío</h3>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label class="block text-gray-700 font-medium mb-2" for="recipient-country">
                País del Destinatario <span class="text-red-500">*</span>
            </label>
            <input
                x-model="formData.recipientCountry"
                type="text"
                id="recipient-country"
                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
                placeholder="País de destino"
                required
            >
        </div>

        <div>
            <label class="block text-gray-700 font-medium mb-2" for="expected-date">
                Fecha de Entrega Esperada
            </label>
            <input
                x-model="formData.expectedDeliveryDate"
                type="date"
                id="expected-date"
                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
            >
        </div>

        <div>
            <label class="block text-gray-700 font-medium mb-2" for="fullname">
                Nombre Completo <span class="text-red-500">*</span>
            </label>
            <input
                x-model="formData.fullName"
                type="text"
                id="fullname"
                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
                placeholder="Tu nombre completo"
                required
            >
        </div>

        <div>
            <label class="block text-gray-700 font-medium mb-2" for="phone">
                Número de Teléfono
            </label>
            <input
                x-model="formData.phone"
                type="tel"
                id="phone"
                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
                placeholder="Tu número de contacto"
            >
        </div>

        <div>
            <label class="block text-gray-700 font-medium mb-2" for="company">
                Nombre de la Empresa
            </label>
            <input
                x-model="formData.companyName"
                type="text"
                id="company"
                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
                placeholder="Nombre de tu empresa (si aplica)"
            >
        </div>

        <div>
            <label class="block text-gray-700 font-medium mb-2" for="dimensions">
                Dimensiones del Paquete
            </label>
            <input
                x-model="formData.dimensions"
                type="text"
                id="dimensions"
                class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
                placeholder="ej., 30cm x 40cm x 20cm"
            >
        </div>
    </div>

    <div class="mt-6">
        <label class="block text-gray-700 font-medium mb-2" for="description">
            Descripción del Envío
        </label>
        <textarea
            x-model="formData.description"
            id="description"
            rows="4"
            class="appearance-none block w-full bg-gray-50 text-gray-700 border border-gray-300 rounded-lg py-3 px-4 leading-tight focus:outline-none focus:bg-white form-input"
            placeholder="Describe el contenido de tu envío"
        ></textarea>
    </div>

    <div class="mt-6">
        <p class="block text-gray-700 font-medium mb-3">
            Prioridad de Envío
        </p>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div
                @click="formData.priority = 'economy'"
                class="border rounded-lg p-4 cursor-pointer transition-all duration-300"
                :class="formData.priority === 'economy' ? 'border-primary bg-primary bg-opacity-5' : 'border-gray-200 hover:bg-gray-50'"
            >
                <div class="flex items-center mb-2">
                    <i class="fas fa-truck-loading text-2xl mr-3 text-gray-400" :class="formData.priority === 'economy' ? 'text-secondary' : 'text-gray-400'"></i>
                    <h4 class="font-medium" :class="formData.priority === 'economy' ? 'text-secondary' : 'text-secondary'">Económica</h4>
                </div>
                <p class="text-sm text-gray-500">Opción económica con tiempos de entrega estándar</p>
            </div>

            <div
                @click="formData.priority = 'standard'"
                class="border rounded-lg p-4 cursor-pointer transition-all duration-300"
                :class="formData.priority === 'standard' ? 'border-primary bg-primary bg-opacity-5' : 'border-gray-200 hover:bg-gray-50'"
            >
                <div class="flex items-center mb-2">
                    <i class="fas fa-shipping-fast text-2xl mr-3 text-gray-400" :class="formData.priority === 'standard' ? 'text-secondary' : 'text-gray-400'"></i>
                    <h4 class="font-medium" :class="formData.priority === 'standard' ? 'text-secondary' : 'text-secondary'">Estándar</h4>
                </div>
                <p class="text-sm text-gray-500">Opción equilibrada entre costo y velocidad de entrega</p>
            </div>

            <div
                @click="formData.priority = 'express'"
                class="border rounded-lg p-4 cursor-pointer transition-all duration-300"
                :class="formData.priority === 'express' ? 'border-primary bg-primary bg-opacity-5' : 'border-gray-200 hover:bg-gray-50'"
            >
                <div class="flex items-center mb-2">
                    <i class="fas fa-rocket text-2xl mr-3 text-gray-400" :class="formData.priority === 'express' ? 'text-secondary' : 'text-gray-400'"></i>
                    <h4 class="font-medium" :class="formData.priority === 'express' ? 'text-secondary' : 'text-secondary'">Exprés</h4>
                </div>
                <p class="text-sm text-gray-500">Opción premium para la entrega más rápida posible</p>
            </div>
        </div>
    </div>

    <div class="mt-6">
        <label class="flex items-center">
            <input
                x-model="formData.insurance"
                type="checkbox"
                class="form-checkbox rounded text-primary focus:ring-primary h-5 w-5 custom-checkbox"
            >
            <span class="ml-2 text-gray-700">Incluir seguro de envío (recomendado)</span>
        </label>
    </div>

    <div class="flex justify-between mt-8">
        <button
            @click="currentStep = 1"
            class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center"
        >
            <i class="fas fa-arrow-left mr-2 text-gray-600"></i>
            Anterior
        </button>

        <button
            @click="if(validateStep2()) currentStep = 3"
            class="bg-primary hover:bg-secondary text-white font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center"
        >
            Revisar Cotización
            <i class="fas fa-arrow-right ml-2 text-white"></i>
        </button>
    </div>
</div>

<!-- Form Step 3: Review Quote -->
<div x-show="currentStep === 3" x-cloak class="p-6">
    <h3 class="text-xl font-semibold text-secondary mb-6">Revisión de Cotización</h3>

    <p class="text-gray-700 mb-4">
        Revise cuidadosamente los detalles de su envío antes de enviar la solicitud de cotización.
    </p>

    <div class="bg-gray-50 border border-gray-200 rounded-lg p-6">
        <h4 class="text-lg font-medium text-secondary mb-4">Resumen del Envío</h4>
        <ul class="text-gray-700 space-y-2">
            <li><strong>Tipo de Flete:</strong> <span x-text="formData.freightType"></span></li>
            <li><strong>Correo Electrónico:</strong> <span x-text="formData.email"></span></li>
            <li><strong>País de Salida:</strong> <span x-text="formData.departureCountry"></span></li>
            <li><strong>País del Destinatario:</strong> <span x-text="formData.recipientCountry"></span></li>
            <li><strong>Nombre Completo:</strong> <span x-text="formData.fullName"></span></li>
            <li><strong>Empresa:</strong> <span x-text="formData.companyName || 'N/A'"></span></li>
            <li><strong>Teléfono:</strong> <span x-text="formData.phone || 'N/A'"></span></li>
            <li><strong>Peso:</strong> <span x-text="formData.weight || 'N/A'"></span> KG</li>
            <li><strong>Dimensiones:</strong> <span x-text="formData.dimensions || 'N/A'"></span></li>
            <li><strong>Prioridad:</strong> <span x-text="formData.priority"></span></li>
            <li><strong>Seguro:</strong> <span x-text="formData.insurance ? 'Sí' : 'No'"></span></li>
            <li><strong>Fecha Esperada de Entrega:</strong> <span x-text="formData.expectedDeliveryDate || 'N/A'"></span></li>
            <li><strong>Descripción:</strong> <span x-text="formData.description || 'N/A'"></span></li>
        </ul>
    </div>

    <div class="flex justify-between mt-8">
        <button
            @click="currentStep = 2"
            class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center"
        >
            <i class="fas fa-arrow-left mr-2 text-gray-600"></i>
            Anterior
        </button>

        <button
            @click="if(validateStep3()) currentStep = 4"
            class="bg-primary hover:bg-secondary text-white font-medium py-3 px-6 rounded-lg transition duration-300 flex items-center"
        >
            Confirmar y Cotizar
            <i class="fas fa-arrow-right ml-2 text-white"></i>
        </button>
    </div>
</div>

<!-- Form Step 4: Success / Submission -->
<div x-show="currentStep === 4" x-cloak class="p-6 text-center">
    <h3 class="text-2xl font-semibold text-secondary mb-6">¡Solicitud Enviada!</h3>

    <p class="text-gray-700 mb-4">
        Su solicitud de cotización ha sido enviada correctamente. Nuestro equipo se pondrá en contacto con usted pronto.
    </p>

    <div class="mt-6">
        <i class="fas fa-check-circle text-green-500 text-6xl"></i>
    </div>

    <div class="mt-8">
        <button
            @click="resetForm()"
            class="bg-primary hover:bg-secondary text-white font-medium py-3 px-6 rounded-lg transition duration-300"
        >
            Enviar Otra Cotización
        </button>
    </div>
</div>

                
                
                
            </div>
        </div>
    </div>
</section>

<!-- Why Choose Us Section -->
<!--<section class="py-16 bg-gray-50">-->
<!--    <div class="container mx-auto px-4">-->
<!--        <div class="max-w-5xl mx-auto">-->
<!--            <div class="text-center mb-12">-->
<!--                <h2 class="text-3xl font-bold text-secondary mb-4">Why Choose Our Shipping Services</h2>-->
<!--                <p class="text-gray-600 max-w-2xl mx-auto">We offer comprehensive shipping solutions with competitive rates and reliable service to meet all your logistics needs.</p>-->
<!--            </div>-->

<!--            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">-->
                <!-- Feature 1 -->
<!--                <div class="bg-white rounded-lg shadow p-6 text-center">-->
<!--                    <div class="bg-primary bg-opacity-10 rounded-full p-4 w-16 h-16 flex items-center justify-center mx-auto mb-4">-->
<!--                        <i class="fas fa-globe text-white text-2xl"></i>-->
<!--                    </div>-->
<!--                    <h3 class="text-lg font-bold text-secondary mb-2">Global Network</h3>-->
<!--                    <p class="text-gray-600">We have an extensive network of partners worldwide ensuring your shipment reaches its destination safely and on time.</p>-->
<!--                </div>-->

                <!-- Feature 2 -->
<!--                <div class="bg-white rounded-lg shadow p-6 text-center">-->
<!--                    <div class="bg-primary bg-opacity-10 rounded-full p-4 w-16 h-16 flex items-center justify-center mx-auto mb-4">-->
<!--                        <i class="fas fa-shield-alt text-white text-2xl"></i>-->
<!--                    </div>-->
<!--                    <h3 class="text-lg font-bold text-secondary mb-2">Secure Shipping</h3>-->
<!--                    <p class="text-gray-600">Your shipments are handled with the utmost care and protected with advanced tracking and security measures.</p>-->
<!--                </div>-->

                <!-- Feature 3 -->
<!--                <div class="bg-white rounded-lg shadow p-6 text-center">-->
<!--                    <div class="bg-primary bg-opacity-10 rounded-full p-4 w-16 h-16 flex items-center justify-center mx-auto mb-4">-->
<!--                        <i class="fas fa-hand-holding-usd text-white text-2xl"></i>-->
<!--                    </div>-->
<!--                    <h3 class="text-lg font-bold text-secondary mb-2">Competitive Pricing</h3>-->
<!--                    <p class="text-gray-600">We offer some of the most competitive rates in the industry without compromising on service quality.</p>-->
<!--                </div>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="max-w-5xl mx-auto">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-secondary mb-4">Por Qué Elegir Nuestros Servicios de Envío</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Ofrecemos soluciones de envío integrales con tarifas competitivas y un servicio confiable para satisfacer todas sus necesidades logísticas.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Feature 1 -->
                <div class="bg-white rounded-lg shadow p-6 text-center">
                    <div class="bg-primary bg-opacity-10 rounded-full p-4 w-16 h-16 flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-globe text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-secondary mb-2">Red Global</h3>
                    <p class="text-gray-600">Contamos con una extensa red de socios en todo el mundo, asegurando que su envío llegue a su destino de manera segura y puntual.</p>
                </div>

                <!-- Feature 2 -->
                <div class="bg-white rounded-lg shadow p-6 text-center">
                    <div class="bg-primary bg-opacity-10 rounded-full p-4 w-16 h-16 flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-shield-alt text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-secondary mb-2">Envío Seguro</h3>
                    <p class="text-gray-600">Sus envíos se manejan con el máximo cuidado y están protegidos con seguimiento avanzado y medidas de seguridad.</p>
                </div>

                <!-- Feature 3 -->
                <div class="bg-white rounded-lg shadow p-6 text-center">
                    <div class="bg-primary bg-opacity-10 rounded-full p-4 w-16 h-16 flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-hand-holding-usd text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-secondary mb-2">Precios Competitivos</h3>
                    <p class="text-gray-600">Ofrecemos algunas de las tarifas más competitivas de la industria sin comprometer la calidad del servicio.</p>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- FAQ Section -->
<!--<section class="py-16 bg-white">-->
<!--    <div class="container mx-auto px-4">-->
<!--        <div class="max-w-5xl mx-auto">-->
<!--            <div class="text-center mb-12">-->
<!--                <h2 class="text-3xl font-bold text-secondary mb-4">Frequently Asked Questions</h2>-->
<!--                <p class="text-gray-600 max-w-2xl mx-auto">Find answers to common questions about our shipping quotes and services.</p>-->
<!--            </div>-->

<!--            <div class="space-y-4" x-data="{active: null}">-->
                <!-- FAQ Item 1 -->
<!--                <div class="border border-gray-200 rounded-lg overflow-hidden">-->
<!--                    <button-->
<!--                        @click="active = active === 1 ? null : 1"-->
<!--                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"-->
<!--                    >-->
<!--                        <span>How long does it take to get a quote?</span>-->
<!--                        <i class="fas" :class="active === 1 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>-->
<!--                    </button>-->

<!--                    <div x-show="active === 1" x-cloak class="p-4 bg-white">-->
<!--                        <p class="text-gray-600">-->
<!--                            After submitting your quote request, you will typically receive a detailed quote within 24 business hours. For complex shipments or during peak times, it may take up to 48 hours to provide an accurate quote.-->
<!--                        </p>-->
<!--                    </div>-->
<!--                </div>-->

                <!-- FAQ Item 2 -->
<!--                <div class="border border-gray-200 rounded-lg overflow-hidden">-->
<!--                    <button-->
<!--                        @click="active = active === 2 ? null : 2"-->
<!--                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"-->
<!--                    >-->
<!--                        <span>What information is needed for an accurate quote?</span>-->
<!--                        <i class="fas" :class="active === 2 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>-->
<!--                    </button>-->

<!--                    <div x-show="active === 2" x-cloak class="p-4 bg-white">-->
<!--                        <p class="text-gray-600">-->
<!--                            To provide the most accurate quote, we need details such as: origin and destination locations, shipment dimensions and weight, type of goods being shipped, desired delivery timeline, and any special handling requirements.-->
<!--                        </p>-->
<!--                    </div>-->
<!--                </div>-->

                <!-- FAQ Item 3 -->
<!--                <div class="border border-gray-200 rounded-lg overflow-hidden">-->
<!--                    <button-->
<!--                        @click="active = active === 3 ? null : 3"-->
<!--                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"-->
<!--                    >-->
<!--                        <span>Do you offer international shipping?</span>-->
<!--                        <i class="fas" :class="active === 3 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>-->
<!--                    </button>-->

<!--                    <div x-show="active === 3" x-cloak class="p-4 bg-white">-->
<!--                        <p class="text-gray-600">-->
<!--                            Yes, we offer comprehensive international shipping services to and from most countries worldwide. Our global network allows us to provide efficient and reliable shipping solutions regardless of your shipment's destination.-->
<!--                        </p>-->
<!--                    </div>-->
<!--                </div>-->

                <!-- FAQ Item 4 -->
<!--                <div class="border border-gray-200 rounded-lg overflow-hidden">-->
<!--                    <button-->
<!--                        @click="active = active === 4 ? null : 4"-->
<!--                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"-->
<!--                    >-->
<!--                        <span>Is shipment insurance included in the quote?</span>-->
<!--                        <i class="fas" :class="active === 4 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>-->
<!--                    </button>-->

<!--                    <div x-show="active === 4" x-cloak class="p-4 bg-white">-->
<!--                        <p class="text-gray-600">-->
<!--                            Basic liability coverage is typically included, but we recommend additional shipping insurance for valuable items. You can select this option during the quote process, and the cost will be included in your final quote.-->
<!--                        </p>-->
<!--                    </div>-->
<!--                </div>-->

                <!-- FAQ Item 5 -->
<!--                <div class="border border-gray-200 rounded-lg overflow-hidden">-->
<!--                    <button-->
<!--                        @click="active = active === 5 ? null : 5"-->
<!--                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"-->
<!--                    >-->
<!--                        <span>How do I track my shipment once it's on the way?</span>-->
<!--                        <i class="fas" :class="active === 5 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>-->
<!--                    </button>-->

<!--                    <div x-show="active === 5" x-cloak class="p-4 bg-white">-->
<!--                        <p class="text-gray-600">-->
<!--                            Once your shipment is processed, you will receive a tracking number that you can use on our website's tracking page. You'll be able to monitor your shipment's progress in real-time with detailed status updates.-->
<!--                        </p>-->
<!--                    </div>-->
<!--                </div>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-5xl mx-auto">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-secondary mb-4">Preguntas Frecuentes</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Encuentre respuestas a preguntas comunes sobre nuestras cotizaciones y servicios de envío.</p>
            </div>

            <div class="space-y-4" x-data="{active: null}">
                <!-- FAQ Item 1 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <button
                        @click="active = active === 1 ? null : 1"
                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"
                    >
                        <span>¿Cuánto tiempo tarda en recibir una cotización?</span>
                        <i class="fas" :class="active === 1 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                    </button>

                    <div x-show="active === 1" x-cloak class="p-4 bg-white">
                        <p class="text-gray-600">
                            Después de enviar su solicitud de cotización, normalmente recibirá una cotización detallada dentro de 24 horas hábiles. Para envíos complejos o en épocas de alta demanda, puede tardar hasta 48 horas en proporcionarse una cotización precisa.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 2 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <button
                        @click="active = active === 2 ? null : 2"
                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"
                    >
                        <span>¿Qué información se necesita para una cotización precisa?</span>
                        <i class="fas" :class="active === 2 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                    </button>

                    <div x-show="active === 2" x-cloak class="p-4 bg-white">
                        <p class="text-gray-600">
                            Para proporcionar la cotización más precisa, necesitamos detalles como: lugares de origen y destino, dimensiones y peso del envío, tipo de mercancía, plazo de entrega deseado y cualquier requisito especial de manejo.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 3 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <button
                        @click="active = active === 3 ? null : 3"
                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"
                    >
                        <span>¿Ofrecen envíos internacionales?</span>
                        <i class="fas" :class="active === 3 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                    </button>

                    <div x-show="active === 3" x-cloak class="p-4 bg-white">
                        <p class="text-gray-600">
                            Sí, ofrecemos servicios completos de envío internacional hacia y desde la mayoría de los países del mundo. Nuestra red global nos permite proporcionar soluciones de envío eficientes y confiables sin importar el destino de su envío.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 4 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <button
                        @click="active = active === 4 ? null : 4"
                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"
                    >
                        <span>¿El seguro de envío está incluido en la cotización?</span>
                        <i class="fas" :class="active === 4 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                    </button>

                    <div x-show="active === 4" x-cloak class="p-4 bg-white">
                        <p class="text-gray-600">
                            Por lo general, se incluye una cobertura básica de responsabilidad, pero recomendamos un seguro adicional para artículos valiosos. Puede seleccionar esta opción durante el proceso de cotización, y el costo se incluirá en su cotización final.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 5 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <button
                        @click="active = active === 5 ? null : 5"
                        class="flex justify-between items-center w-full p-4 text-left font-medium text-secondary bg-gray-50 hover:bg-gray-100 focus:outline-none transition-all"
                    >
                        <span>¿Cómo puedo rastrear mi envío una vez que esté en camino?</span>
                        <i class="fas" :class="active === 5 ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                    </button>

                    <div x-show="active === 5" x-cloak class="p-4 bg-white">
                        <p class="text-gray-600">
                            Una vez que su envío sea procesado, recibirá un número de seguimiento que podrá usar en la página de seguimiento de nuestro sitio web. Podrá monitorear el progreso de su envío en tiempo real con actualizaciones detalladas de estado.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- Call to Action Section -->
<!--<section class="py-12 bg-secondary relative">-->
<!--    <div class="container mx-auto px-4">-->
<!--        <div class="flex flex-col md:flex-row items-center justify-between">-->
<!--            <div class="mb-6 md:mb-0">-->
<!--                <h2 class="text-2xl md:text-3xl font-bold text-white">Ready to Ship Your Package?</h2>-->
<!--                <p class="text-white text-opacity-90 mt-2">Get in touch today for a free shipping quote!</p>-->
<!--            </div>-->
<!--            <div class="flex flex-wrap gap-4">-->
<!--                <a href="contact" class="bg-white text-secondary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">-->
<!--                    <i class="fas fa-phone-alt mr-2 text-secondary"></i>-->
<!--                    Contact Us-->
<!--                </a>-->
<!--                <a href="track-order" class="bg-primary text-white hover:bg-opacity-90 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">-->
<!--                    <i class="fas fa-search mr-2 text-white"></i>-->
<!--                    Track Shipment-->
<!--                </a>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->

    <!-- Wave Pattern Bottom -->
<!--    <div class="absolute bottom-0 left-0 right-0">-->
<!--        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 48" class="text-white fill-current">-->
<!--            <path d="M0,0L48,8C96,16,192,32,288,32C384,32,480,16,576,16C672,16,768,32,864,37.3C960,43,1056,37,1152,32C1248,27,1344,21,1392,18.7L1440,16L1440,48L1392,48C1344,48,1248,48,1152,48C1056,48,960,48,864,48C768,48,672,48,576,48C480,48,384,48,288,48C192,48,96,48,48,48L0,48Z"></path>-->
<!--        </svg>-->
<!--    </div>-->
<!--</section>-->
<section class="py-12 bg-secondary relative">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="mb-6 md:mb-0">
                <h2 class="text-2xl md:text-3xl font-bold text-white">¿Listo para enviar su paquete?</h2>
                <p class="text-white text-opacity-90 mt-2">¡Póngase en contacto hoy para una cotización de envío gratuita!</p>
            </div>
            <div class="flex flex-wrap gap-4">
                <a href="contact" class="bg-white text-secondary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i class="fas fa-phone-alt mr-2 text-secondary"></i>
                    Contáctenos
                </a>
                <a href="track-order" class="bg-primary text-white hover:bg-opacity-90 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i class="fas fa-search mr-2 text-white"></i>
                    Rastrear Envío
                </a>
            </div>
        </div>
    </div>

    <!-- Wave Pattern Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 48" class="text-white fill-current">
            <path d="M0,0L48,8C96,16,192,32,288,32C384,32,480,16,576,16C672,16,768,32,864,37.3C960,43,1056,37,1152,32C1248,27,1344,21,1392,18.7L1440,16L1440,48L1392,48C1344,48,1248,48,1152,48C1056,48,960,48,864,48C768,48,672,48,576,48C480,48,384,48,288,48C192,48,96,48,48,48L0,48Z"></path>
        </svg>
    </div>
</section>


@push('scripts')
<script>
    // Fix Font Awesome icons visibility
    document.addEventListener('DOMContentLoaded', function() {
        // Ensure all Font Awesome icons are visible
        ensureIconsAreVisible();

        // Set up MutationObserver to monitor DOM changes by Alpine.js
        const observer = new MutationObserver(function(mutations) {
            ensureIconsAreVisible();
        });

        // Start observing the document with the configured parameters
        observer.observe(document.body, {
            childList: true,
            subtree: true,
            attributes: true,
            attributeFilter: ['style', 'class']
        });

        function ensureIconsAreVisible() {
            // Force display of all Font Awesome icons
            document.querySelectorAll('.fas, .fab, .far, .fa, .fa-icon, .quote-icon').forEach(function(icon) {
                icon.style.display = 'inline-block';
                icon.style.visibility = 'visible';
                icon.style.opacity = '1';

                // Fix for icons in specific backgrounds
                const parent = icon.closest('.bg-primary, .bg-primary-light, [class*="bg-primary"]');
                if (parent) {
                    icon.style.color = '#ffffff';
                }
            });
        }

        // Additional fix: periodically check if icons are visible
        setInterval(ensureIconsAreVisible, 1000);
    });

    // Handle form submission (can be customized based on your backend)
    document.addEventListener('alpine:init', () => {
        Alpine.data('quoteForm', () => ({
            // Form data and methods defined in the markup
        }))
    })
</script>
@endpush

@endsection
