@extends('layouts.invoice')

@section('title', $settings->site_title)


@inject('content', 'App\Http\Controllers\FrontController')
@section('content')

  <body  style="background-color:teal;"  onload="window.print();">



<div class="wrapper" id="background">
  <p id="bg-text">Copia Certificada Fiel</p>

  <!-- Contenido principal -->
  <section class="invoice">
    <!-- fila del título -->
    <div class="row">
      <div class="col-xs-12">
        <h2 class="page-header">
          <span>
            <img src="{{ asset('storage/app/public/'.$settings->logo)}}" height="45" width='130'>

            <img class="pull-right" src="{{ asset('temp/custom/banner.png') }}" alt="" height="185"/>

            <h3 style="color:red;">
              <strong>Número de Seguimiento: {{$user->trackingnumber}}</strong>
            </h3>
          </span>
        </h2>
      </div><!-- /.col -->
    </div>

    <div class="row">
      <div class="col-xs-12">
        <h2 class="page-header">
          <center>
            <strong style="color:green;">
              {{$settings->site_name}} Compañía Logística<br>
              Dirección: Barcelona, ESPAÑA<br>
              Correo electrónico: {{$settings->contact_email}}<br>
              Sitio web de la empresa: {{$settings->site_address}}
            </strong>
          </center>
        </h2>
      </div><!-- /.col -->
    </div>

    <!-- fila de información -->
    <div class="row invoice-info">
      <div class="col-sm-4 invoice-col">
        <strong style="color:blue;">DE (REMITENTE)</strong>
        <address>
          <h3><strong style="color:green;">{{$user->sname}}</strong></h3>
          <b>Dirección:</b> {{$user->saddress}}<br/>
          <b>Oficina de Origen:</b> {{ $user->take_off_point }}
        </address>
      </div><!-- /.col -->

      <div class="col-sm-4 invoice-col">
        <strong style="color:blue;">A (DESTINATARIO)</strong>
        <address>
          <h3><strong style="color:green;">{{$user->name}}</strong></h3>
          <b>Teléfono:</b> {{$user->phone}}<br/>
          <b>Dirección:</b> {{$user->address}}<br/>
          <b>Oficina de Destino:</b> {{ $user->final_destination }}
        </address>
      </div><!-- /.col -->

      <div class="col-sm-4 invoice-col">
        <table>
          <tr>
            <td>
              <center>
                <img src="https://barcode.tec-it.com/barcode.ashx?data={{ $user->trackingnumber }}&code=Code128" alt="{{ $user->trackingnumber }}"><br>
              </center>
            </td>
          </tr>
        </table>
        <br/>
        <b>ID del Pedido:</b>&nbsp;&nbsp;{{ $user->id }} <br/>
        <b>Modo de Reserva:</b> <small class="label label-danger"><i class="fa fa-money"></i>&nbsp;&nbsp;Por Pagar</small><br/>
        <b>Costo de Envío:</b>&nbsp;{{ $settings->s_currency }}&nbsp;{{ $user->cost }}<br/>
        <b>Número de Seguimiento:</b>&nbsp;&nbsp;{{ $user->trackingnumber }} <br/>
      </div><!-- /.col -->
    </div><!-- /.row -->

    <!-- fila de la tabla -->
    <div class="row">
      <div class="col-xs-12 table-responsive">
        <table class="table table-striped">
          <thead>
            <tr>
              <th>Cant.</th>
              <th>Producto</th>
              <th>Estado</th>
              <th>Descripción</th>
              <th>Costo de Envío</th>
              <th>Costo de Despacho</th>
              <th>Costo Total</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>{{$user->qty }}</td>
              <td>Paquete</td>
              <td><small class="label label-success">{{ $user->status }} </small></td>
              <td>{{ $user->description }} </td>
              <td>{{ $settings->s_currency }}&nbsp;{{ $user->cost }} </td>
              <td>{{ $settings->s_currency }}&nbsp;{{ $user->clearance_cost }}</td>
              <td>{{ $settings->s_currency }}&nbsp;{{ $user->clearance_cost+$user->cost }}</td>
            </tr>
          </tbody>
        </table>
      </div><!-- /.col -->
    </div><!-- /.row -->
    <br><br>

    <div class="row">
      <!-- columna de pagos aceptados -->
      <div class="col-xs-4">
        <p class="lead"><strong>Métodos de Pago:</strong></p>
        <img src="{{ asset('temp/securepayment.png') }}" alt="Métodos de pago" />
        <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
          Para su comodidad, en {{ $settings->site_name }} ofrecemos varios métodos de pago confiables, rápidos y seguros.
        </p>
      </div>

      <div class="col-xs-4">
        <p class="lead"><strong>Sello Oficial/{{ \Carbon\Carbon::parse($user->created_at)->toDayDateTimeString() }}</strong></p>
        <img src="{{ asset('temp/stamp1.png') }}" alt="" height="100" />
      </div>

      <div class="col-xs-4">
        <p class="lead">Impuesto de Timbre:</p>
        <img class='text-center' src="{{ asset('temp/stamp2.png') }}" alt="" height="100"/>
      </div>

      <!-- /.col -->
      <div class="col-xs-6">
        <p class="lead"><strong>Monto a Pagar</strong></p>
        <div class="table-responsive">
          <table class="table">
            <tr>
              <th style="width:50%">COSTO DE ENVÍO:</th>
              <th>COSTO DE DESPACHO:</th>
              <th>MONTO TOTAL:</th>
            </tr>
            <tr>
              <td>{{ $settings->s_currency }}&nbsp;{{ $user->cost }}</td>
              <td>{{ $settings->s_currency }}&nbsp;{{ $user->clearance_cost }}</td>
              <td>{{ $settings->s_currency }}&nbsp;{{ $user->clearance_cost+$user->cost }}</td>
            </tr>
          </table>
        </div>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </section><!-- /.content -->
</div><!-- ./wrapper -->


    @endsection
