@extends('layouts.base')

@section('title', 'About Us')

@inject('content', 'App\Http\Controllers\FrontController')
@section('content')

<!-- Page Header -->
<section class="relative bg-secondary py-16">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute inset-0 bg-secondary bg-opacity-90"></div>
        <div class="absolute w-96 h-96 -top-20 -left-20 bg-white opacity-5 rounded-full"></div>
        <div class="absolute w-96 h-96 bottom-0 right-0 bg-primary opacity-5 rounded-full"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col items-center">
            <h1 class="text-3xl md:text-4xl font-bold text-white mb-4">About Our Company</h1>
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="flex items-center space-x-2 text-sm text-white">
                    <li>
                        <a href="/" class="hover:text-primary transition-all">Home</a>
                    </li>
                    <li class="flex items-center">
                        <i data-lucide="chevron-right" class="w-4 h-4 mx-1"></i>
                        <span class="text-primary">About Us</span>
                    </li>
                </ol>
            </nav>
        </div>
    </div>
    
    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>
        </svg>
    </div>
</section>

<!-- Company History Section -->
<section class="py-16 bg-white" x-data="{ activeTab: 'history' }">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row gap-12">
            <!-- Left Content -->
            <div class="w-full md:w-2/3">
                <!-- Section Title -->
                <div class="flex items-center mb-6">
                    <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">01</div>
                    <h2 class="text-3xl font-bold text-secondary">{{$settings->site_name}}</h2>
                </div>
                
                <!-- Tabs Navigation -->
                <div class="flex border-b border-gray-200 mb-6">
                    <button 
                        @click="activeTab = 'history'" 
                        :class="{'border-b-2 border-primary text-primary': activeTab === 'history', 'text-gray-500': activeTab !== 'history'}"
                        class="pb-2 px-4 font-medium text-sm focus:outline-none transition-all"
                    >
                        Our History
                    </button>
                    <button 
                        @click="activeTab = 'mission'" 
                        :class="{'border-b-2 border-primary text-primary': activeTab === 'mission', 'text-gray-500': activeTab !== 'mission'}"
                        class="pb-2 px-4 font-medium text-sm focus:outline-none transition-all"
                    >
                        Mission & Vision
                    </button>
                    <button 
                        @click="activeTab = 'values'" 
                        :class="{'border-b-2 border-primary text-primary': activeTab === 'values', 'text-gray-500': activeTab !== 'values'}"
                        class="pb-2 px-4 font-medium text-sm focus:outline-none transition-all"
                    >
                        Our Values
                    </button>
                </div>
                
                <!-- Tab Content - History -->
                <div x-show="activeTab === 'history'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-x-4" x-transition:enter-end="opacity-100 transform translate-x-0">
                    <h3 class="text-xl font-bold text-secondary mb-4">One of the leaders in the heavy haulage and abnormal load business</h3>
                    <p class="text-gray-600 mb-4">Back in 1971, recognising an opportunity to serve the northeast fishing community, Steve and Helen Hardy launched a road haulage company called S & H Hardy. In direct competition with Charles Crouch and Partners, who were then one of the biggest haulage companies in Scotland, their fleet of 25 vehicles transported fresh fish from Peterhead to Humberside and Tyneside on a daily basis. Moving from their base in Laurencekirk into Aberdeen in 1980 to purchase Tullos Cold Store the company was able to diversify into hauling both fresh and frozen goods all over the UK and Europe.</p>
                    
                    <div class="bg-gray-50 border-l-4 border-primary p-4 my-6">
                        <p class="text-gray-600 italic">1984 saw a severe downturn in the fish industry, which led the company to diversify again into the oil industry. The cold store side of the business was sold in 1988 to concentrate on the oil and paper industries throughout the UK and Europe.</p>
                    </div>
                    
                    <p class="text-gray-600 mb-8">In 1990 Steve and Helen son Mark joined the firm and MGS Transport was established. The following year, the first Stepframe trailer was purchased to specialise in heavy haulage and abnormal loads for the oil industry. With the addition of the first Lowloader in 1996, the company has become one of the leaders in the heavy haulage and abnormal load business.</p>
                    
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-6 mt-6">
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-full p-2 mr-3">
                                    <i data-lucide="calendar" class="w-5 h-5 text-primary"></i>
                                </div>
                                <h4 class="font-bold text-secondary">1971</h4>
                            </div>
                            <p class="text-sm text-gray-600">Company founded by Steve and Helen Hardy, starting with a fleet of 25 vehicles.</p>
                        </div>
                        
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-full p-2 mr-3">
                                    <i data-lucide="calendar" class="w-5 h-5 text-primary"></i>
                                </div>
                                <h4 class="font-bold text-secondary">1980</h4>
                            </div>
                            <p class="text-sm text-gray-600">Moved from Laurencekirk to Aberdeen and purchased Tullos Cold Store for expansion.</p>
                        </div>
                        
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-full p-2 mr-3">
                                    <i data-lucide="calendar" class="w-5 h-5 text-primary"></i>
                                </div>
                                <h4 class="font-bold text-secondary">1990</h4>
                            </div>
                            <p class="text-sm text-gray-600">Mark Hardy joined the firm and MGS Transport was established.</p>
                        </div>
                        
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-full p-2 mr-3">
                                    <i data-lucide="calendar" class="w-5 h-5 text-primary"></i>
                                </div>
                                <h4 class="font-bold text-secondary">1996</h4>
                            </div>
                            <p class="text-sm text-gray-600">First Lowloader was purchased, establishing leadership in the heavy haulage business.</p>
                        </div>
                    </div>
                </div>
                
                <!-- Tab Content - Mission -->
                <div x-show="activeTab === 'mission'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-x-4" x-transition:enter-end="opacity-100 transform translate-x-0" style="display: none;">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-4">
                                <div class="bg-primary text-white rounded-full p-2 mr-3">
                                    <i data-lucide="target" class="w-5 h-5"></i>
                                </div>
                                <h3 class="text-xl font-bold text-secondary">Our Mission</h3>
                            </div>
                            <p class="text-gray-600">To provide industry-leading logistics and transportation services that exceed customer expectations through reliability, efficiency, and innovation, while maintaining the highest standards of safety and environmental responsibility.</p>
                        </div>
                        
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-4">
                                <div class="bg-primary text-white rounded-full p-2 mr-3">
                                    <i data-lucide="eye" class="w-5 h-5"></i>
                                </div>
                                <h3 class="text-xl font-bold text-secondary">Our Vision</h3>
                            </div>
                            <p class="text-gray-600">To be the global leader in transportation and logistics solutions, recognized for our innovation, service excellence, and commitment to sustainability in every region we operate.</p>
                        </div>
                    </div>
                    
                    <div class="bg-gray-50 rounded-lg p-6 mt-6">
                        <h3 class="text-xl font-bold text-secondary mb-4">Strategic Goals</h3>
                        <ul class="space-y-3">
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-primary mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Expand our international presence to 200+ countries by 2028</span>
                            </li>
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-primary mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Achieve carbon neutrality in our operations by 2030</span>
                            </li>
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-primary mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Integrate cutting-edge technologies to enhance tracking and logistics efficiency</span>
                            </li>
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-primary mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Maintain a 98% customer satisfaction rating through service excellence</span>
                            </li>
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-primary mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Develop and retain the industry's most skilled and diverse workforce</span>
                            </li>
                        </ul>
                    </div>
                </div>
                
                <!-- Tab Content - Values -->
                <div x-show="activeTab === 'values'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-x-4" x-transition:enter-end="opacity-100 transform translate-x-0" style="display: none;">
                    <p class="text-gray-600 mb-6">Our core values guide every decision we make and every action we take as we work to fulfill our mission and achieve our vision.</p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="shield" class="w-6 h-6 text-primary"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Safety First</h4>
                            <p class="text-gray-600 text-sm">We prioritize the safety of our team, customers, and communities in everything we do.</p>
                        </div>
                        
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="heart-handshake" class="w-6 h-6 text-primary"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Customer Focus</h4>
                            <p class="text-gray-600 text-sm">We are committed to understanding and exceeding our customers' expectations.</p>
                        </div>
                        
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="users" class="w-6 h-6 text-primary"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Teamwork</h4>
                            <p class="text-gray-600 text-sm">We collaborate effectively across functions, geographies and cultures.</p>
                        </div>
                        
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="lightbulb" class="w-6 h-6 text-primary"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Innovation</h4>
                            <p class="text-gray-600 text-sm">We continuously seek new ideas and technologies to improve our services.</p>
                        </div>
                        
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="globe" class="w-6 h-6 text-primary"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Sustainability</h4>
                            <p class="text-gray-600 text-sm">We operate responsibly to minimize our environmental impact.</p>
                        </div>
                        
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="check-circle-2" class="w-6 h-6 text-primary"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Integrity</h4>
                            <p class="text-gray-600 text-sm">We uphold the highest ethical standards in all our business practices.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Right Sidebar -->
            <div class="w-full md:w-1/3">
                <!-- Company Image -->
                <div class="mb-6">
                    <img src="temp/custom/images/image1.jpg" alt="Company Image" class="rounded-lg shadow-md w-full">
                    <div class="bg-gray-100 p-3 text-center text-sm text-gray-600 mt-2 rounded">
                        <p>Member of the Road Haulage Association</p>
                    </div>
                </div>
                
                <!-- PDF Download -->
                <div class="bg-gray-50 rounded-lg p-6 flex items-center mb-6 hover:bg-gray-100 transition-all">
                    <div class="bg-primary text-white rounded-full p-3 mr-4">
                        <i data-lucide="file-text" class="w-6 h-6"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-secondary mb-1">Company Brochure</h4>
                        <a href="#" class="text-primary hover:text-secondary flex items-center">
                            <span>Download PDF</span>
                            <i data-lucide="download" class="w-4 h-4 ml-1"></i>
                        </a>
                    </div>
                </div>
                
                <!-- Quick Contact -->
                <div class="bg-secondary rounded-lg p-6 text-white">
                    <h3 class="font-bold text-xl mb-4">Need Assistance?</h3>
                    <ul class="space-y-3">
                        <li class="flex items-start">
                            <i data-lucide="phone" class="w-5 h-5 mr-3 mt-0.5"></i>
                            <div>
                                <p class="text-sm opacity-75">Call us at</p>
                                <p class="font-medium">{{ $settings->whatsapp }}</p>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <i data-lucide="mail" class="w-5 h-5 mr-3 mt-0.5"></i>
                            <div>
                                <p class="text-sm opacity-75">Email us at</p>
                                <p class="font-medium">{{ $settings->contact_email }}</p>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <i data-lucide="map-pin" class="w-5 h-5 mr-3 mt-0.5"></i>
                            <div>
                                <p class="text-sm opacity-75">Our location</p>
                                <p class="font-medium">{{ $settings->locations }}</p>
                            </div>
                        </li>
                    </ul>
                    <div class="mt-4">
                        <a href="contact" class="bg-primary text-white py-2 px-4 rounded flex items-center justify-center">
                            <i data-lucide="message-square" class="w-4 h-4 mr-2"></i>
                            Contact Us
                        </a>
                    </div>
                </div>
                
                <!-- Additional image -->
                <div class="mt-6">
                    <img src="temp/custom/images/delivery-trucks.jpg" alt="Delivery Trucks" class="rounded-lg shadow-md w-full">
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Our Services Section -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <!-- Section Title -->
        <div class="flex items-center mb-8">
            <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">02</div>
            <h2 class="text-3xl font-bold text-secondary">OUR PROFESSIONS</h2>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Service 1 -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300 group">
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4 group-hover:bg-primary group-hover:text-white transition-all duration-300">
                    <i data-lucide="plane" class="w-8 h-8 text-primary group-hover:text-white"></i>
                </div>
                <h3 class="text-lg font-bold text-secondary mb-2">AIR SHIPPING</h3>
                <p class="text-gray-600">We can also offer outside storage facilities in Aberdeen and both outside and inside storage in Cowdenbeath.</p>
                <a href="services" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                    Learn More
                    <i data-lucide="chevron-right" class="w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1"></i>
                </a>
            </div>
            
            <!-- Service 2 -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300 group">
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4 group-hover:bg-primary group-hover:text-white transition-all duration-300">
                    <i data-lucide="car" class="w-8 h-8 text-primary group-hover:text-white"></i>
                </div>
                <h3 class="text-lg font-bold text-secondary mb-2">GROUND LOGISTIC</h3>
                <p class="text-gray-600">We can also offer outside storage facilities in Aberdeen and both outside and inside storage in Cowdenbeath.</p>
                <a href="services" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                    Learn More
                    <i data-lucide="chevron-right" class="w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1"></i>
                </a>
            </div>
            
            <!-- Service 3 -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300 group">
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4 group-hover:bg-primary group-hover:text-white transition-all duration-300">
                    <i data-lucide="ship" class="w-8 h-8 text-primary group-hover:text-white"></i>
                </div>
                <h3 class="text-lg font-bold text-secondary mb-2">SEA TRANSPORTATION</h3>
                <p class="text-gray-600">We can also offer outside storage facilities in Aberdeen and both outside and inside storage in Cowdenbeath.</p>
                <a href="services" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                    Learn More
                    <i data-lucide="chevron-right" class="w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1"></i>
                </a>
            </div>
            
            <!-- Service 4 -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300 group">
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4 group-hover:bg-primary group-hover:text-white transition-all duration-300">
                    <i data-lucide="package" class="w-8 h-8 text-primary group-hover:text-white"></i>
                </div>
                <h3 class="text-lg font-bold text-secondary mb-2">DOMESTIC CARGO</h3>
                <p class="text-gray-600">We can also offer outside storage facilities in Aberdeen and both outside and inside storage in Cowdenbeath.</p>
                <a href="services" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                    Learn More
                    <i data-lucide="chevron-right" class="w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Team Members Section -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <!-- Section Title -->
        <div class="flex items-center mb-6">
            <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">03</div>
            <h2 class="text-3xl font-bold text-secondary">BOARD MEMBERS</h2>
        </div>
        
        <p class="text-gray-600 max-w-3xl mb-12">Saw the opening of an office in Uithoorn in the Netherlands to service a growing European market and in 2005 opened a base in Great Yarmouth to service the busy oil industry to and from Aberdeen.</p>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6" x-data="{ activeIndex: null }">
            <!-- Team Member 1 -->
            <div 
                class="bg-white rounded-lg overflow-hidden shadow-md group"
                x-on:mouseenter="activeIndex = 0"
                x-on:mouseleave="activeIndex = null"
            >
                <div class="relative">
                    <img src="temp/custom/images/member1.jpg" alt="John Harris" class="w-full h-64 object-cover">
                    <div 
                        class="absolute inset-0 bg-primary bg-opacity-80 flex flex-col justify-center items-center text-white p-4 transition-all duration-300"
                        :class="{'opacity-0': activeIndex !== 0, 'opacity-100': activeIndex === 0}"
                    >
                        <h4 class="font-bold text-xl mb-2">John Harris</h4>
                        <p class="mb-4 text-center">Over 15 years experience in international logistics and supply chain management.</p>
                        <div class="flex space-x-3">
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="linkedin" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="mail" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="phone" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <h4 class="font-bold text-secondary">John Harris</h4>
                    <p class="text-sm text-gray-500">Business Analyst</p>
                </div>
            </div>
            
            <!-- Team Member 2 -->
            <div 
                class="bg-white rounded-lg overflow-hidden shadow-md group"
                x-on:mouseenter="activeIndex = 1"
                x-on:mouseleave="activeIndex = null"
            >
                <div class="relative">
                    <img src="temp/custom/images/member2.jpg" alt="Louise O'Donnell" class="w-full h-64 object-cover">
                    <div 
                        class="absolute inset-0 bg-primary bg-opacity-80 flex flex-col justify-center items-center text-white p-4 transition-all duration-300"
                        :class="{'opacity-0': activeIndex !== 1, 'opacity-100': activeIndex === 1}"
                    >
                        <h4 class="font-bold text-xl mb-2">Louise O'Donnell</h4>
                        <p class="mb-4 text-center">Marketing expert with a focus on digital strategy and brand development for logistics companies.</p>
                        <div class="flex space-x-3">
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="linkedin" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="mail" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="phone" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <h4 class="font-bold text-secondary">Louise O'Donnell</h4>
                    <p class="text-sm text-gray-500">Marketing Manager</p>
                </div>
            </div>
            
            <!-- Team Member 3 -->
            <div 
                class="bg-white rounded-lg overflow-hidden shadow-md group"
                x-on:mouseenter="activeIndex = 2"
                x-on:mouseleave="activeIndex = null"
            >
                <div class="relative">
                    <img src="temp/custom/images/member3.jpg" alt="Bernard Crotty" class="w-full h-64 object-cover">
                    <div 
                        class="absolute inset-0 bg-primary bg-opacity-80 flex flex-col justify-center items-center text-white p-4 transition-all duration-300"
                        :class="{'opacity-0': activeIndex !== 2, 'opacity-100': activeIndex === 2}"
                    >
                        <h4 class="font-bold text-xl mb-2">Bernard Crotty</h4>
                        <p class="mb-4 text-center">Experienced leadership in global logistics operations and strategic business development.</p>
                        <div class="flex space-x-3">
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="linkedin" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="mail" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="phone" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <h4 class="font-bold text-secondary">Bernard Crotty</h4>
                    <p class="text-sm text-gray-500">Senior Partner</p>
                </div>
            </div>
            
            <!-- Team Member 4 -->
            <div 
                class="bg-white rounded-lg overflow-hidden shadow-md group"
                x-on:mouseenter="activeIndex = 3"
                x-on:mouseleave="activeIndex = null"
            >
                <div class="relative">
                    <img src="temp/custom/images/member4.jpg" alt="Melanie Saunders" class="w-full h-64 object-cover">
                    <div 
                        class="absolute inset-0 bg-primary bg-opacity-80 flex flex-col justify-center items-center text-white p-4 transition-all duration-300"
                        :class="{'opacity-0': activeIndex !== 3, 'opacity-100': activeIndex === 3}"
                    >
                        <h4 class="font-bold text-xl mb-2">Melanie Saunders</h4>
                        <p class="mb-4 text-center">Financial expert specializing in international logistics and transportation accounting.</p>
                        <div class="flex space-x-3">
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="linkedin" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="mail" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="phone" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <h4 class="font-bold text-secondary">Melanie Saunders</h4>
                    <p class="text-sm text-gray-500">Accounting</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Our Partners -->
<section class="py-12 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-8">
            <h2 class="text-2xl font-bold text-secondary">Our Trusted Partners</h2>
            <p class="text-gray-600 mt-2">Companies who trust our services worldwide</p>
        </div>
        
        <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-6 gap-4 items-center">
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo1.jpg" alt="Partner" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo2.jpg" alt="Partner" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo3.jpg" alt="Partner" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo4.jpg" alt="Partner" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo5.jpg" alt="Partner" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo6.jpg" alt="Partner" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="py-12 bg-secondary relative">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="mb-6 md:mb-0">
                <h2 class="text-2xl md:text-3xl font-bold text-white">Ready to Ship Your Package?</h2>
                <p class="text-white text-opacity-90 mt-2">Contact us today for a free shipping quote!</p>
            </div>
            <div class="flex flex-wrap gap-4">
                <a href="contact" class="bg-white text-primary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i data-lucide="phone" class="w-5 h-5 mr-2"></i>
                    Contact Us
                </a>
                <a href="request-quote" class="bg-primary text-white hover:bg-primary-dark py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i data-lucide="clipboard-check" class="w-5 h-5 mr-2"></i>
                    Get a Quote
                </a>
            </div>
        </div>
    </div>
    
    <!-- Wave Pattern Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 48" class="text-white fill-current">
            <path d="M0,0L48,8C96,16,192,32,288,32C384,32,480,16,576,16C672,16,768,32,864,37.3C960,43,1056,37,1152,32C1248,27,1344,21,1392,18.7L1440,16L1440,48L1392,48C1344,48,1248,48,1152,48C1056,48,960,48,864,48C768,48,672,48,576,48C480,48,384,48,288,48C192,48,96,48,48,48L0,48Z"></path>
        </svg>
    </div>
</section>

@endsection
