@extends('layouts.base')

@section('title', 'About Us')

@inject('content', 'App\Http\Controllers\FrontController')
@section('content')

<!-- Page Header -->
<section class="relative bg-secondary py-16">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute inset-0 bg-secondary bg-opacity-90"></div>
        <div class="absolute w-96 h-96 -top-20 -left-20 bg-white opacity-5 rounded-full"></div>
        <div class="absolute w-96 h-96 bottom-0 right-0 bg-primary opacity-5 rounded-full"></div>
    </div>

    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col items-center">
            <h1 class="text-3xl md:text-4xl font-bold text-white mb-4">Acerca de Nuestra Empresa</h1>
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="flex items-center space-x-2 text-sm text-white">
                    <li>
                        <a href="/" class="hover:text-primary transition-all">Inicio</a>
                    </li>
                    <li class="flex items-center">
                        <i data-lucide="chevron-right" class="w-4 h-4 mx-1"></i>
                        <span class="text-primary">Sobre Nosotros</span>
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>
        </svg>
    </div>
</section>

<section class="py-16 bg-white" x-data="{ activeTab: 'history' }" x-cloak>
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row gap-12">
            <!-- Left Content -->
            <div class="w-full md:w-2/3">
                <!-- Section Title -->
                <div class="flex items-center mb-6">
                    <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">01</div>
                    <h2 class="text-3xl font-bold text-secondary">{{$settings->site_name}}</h2>
                </div>

                <!-- Tabs Navigation -->
                <div class="flex border-b border-gray-200 mb-6">
                    <button
                        @click="activeTab = 'history'"
                        :class="{'border-b-2 border-primary text-primary': activeTab === 'history', 'text-gray-500': activeTab !== 'history'}"
                        class="pb-2 px-4 font-medium text-sm focus:outline-none transition-all"
                    >
                        Nuestra Historia
                    </button>
                    <button
                        @click="activeTab = 'mission'"
                        :class="{'border-b-2 border-primary text-primary': activeTab === 'mission', 'text-gray-500': activeTab !== 'mission'}"
                        class="pb-2 px-4 font-medium text-sm focus:outline-none transition-all"
                    >
                        Misión & Visión
                    </button>
                    <button
                        @click="activeTab = 'values'"
                        :class="{'border-b-2 border-primary text-primary': activeTab === 'values', 'text-gray-500': activeTab !== 'values'}"
                        class="pb-2 px-4 font-medium text-sm focus:outline-none transition-all"
                    >
                        Nuestros Valores
                    </button>
                </div>

                <!-- Tab Content - History -->
                <div x-show="activeTab === 'history'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-x-4" x-transition:enter-end="opacity-100 transform translate-x-0">
                    <h3 class="text-xl font-bold text-secondary mb-4">Uno de los líderes en transporte pesado y cargas especiales</h3>
                    <p class="text-gray-600 mb-4">En 1971, reconociendo una oportunidad de servir a la comunidad pesquera del noreste, Steve y Helen Hardy lanzaron una empresa de transporte por carretera llamada S & H Hardy. En competencia directa con Charles Crouch and Partners, que en ese momento era una de las compañías de transporte más grandes de Escocia, su flota de 25 vehículos transportaba pescado fresco de Peterhead a Humberside y Tyneside a diario. Tras trasladarse de su base en Laurencekirk a Aberdeen en 1980 para adquirir Tullos Cold Store, la empresa pudo diversificarse transportando tanto productos frescos como congelados por todo el Reino Unido y Europa.</p>

                    <div class="bg-gray-50 border-l-4 border-primary p-4 my-6">
                        <p class="text-gray-600 italic">En 1984 hubo una grave caída en la industria pesquera, lo que llevó a la empresa a diversificarse nuevamente en la industria del petróleo. La parte de almacenamiento en frío se vendió en 1988 para concentrarse en las industrias del petróleo y el papel en todo el Reino Unido y Europa.</p>
                    </div>

                    <p class="text-gray-600 mb-8">En 1990, el hijo de Steve y Helen, Mark, se unió a la empresa y se estableció MGS Transport. Al año siguiente, se adquirió el primer remolque Stepframe para especializarse en transporte pesado y cargas especiales para la industria petrolera. Con la adquisición del primer Lowloader en 1996, la compañía se convirtió en uno de los líderes en transporte pesado y cargas especiales.</p>

                    <!-- Professional Company Image -->
                    <div class="mb-8 rounded-lg overflow-hidden shadow-lg">
                        <img src="temp/custom/images/banner1.jpg" alt="Operaciones de Transporte Profesional" class="w-full h-64 object-cover">
                        <div class="bg-gradient-to-r from-secondary to-primary p-4 text-white text-center">
                            <p class="font-medium">Excelencia en Transporte & Logística desde 1971</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-6 mt-6">
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-full p-2 mr-3">
                                    <i data-lucide="calendar" class="w-5 h-5 text-white"></i>
                                </div>
                                <h4 class="font-bold text-secondary">1971</h4>
                            </div>
                            <p class="text-sm text-gray-600">La empresa fue fundada por Steve y Helen Hardy, comenzando con una flota de 25 vehículos.</p>
                        </div>

                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-3">
                               <div class="bg-primary bg-opacity-10 rounded-full p-2 mr-3">
  <i data-lucide="calendar" class="w-5 h-5 text-white"></i>
</div>

                                <h4 class="font-bold text-secondary">1980</h4>
                            </div>
                            <p class="text-sm text-gray-600">Se trasladaron de Laurencekirk a Aberdeen y adquirieron Tullos Cold Store para expandirse.</p>
                        </div>

                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-full p-2 mr-3">
                                    <i data-lucide="calendar" class="w-5 h-5 text-white"></i>
                                </div>
                                <h4 class="font-bold text-secondary">1990</h4>
                            </div>
                            <p class="text-sm text-gray-600">Mark Hardy se unió a la empresa y se estableció MGS Transport.</p>
                        </div>

                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-full p-2 mr-3">
                                    <i data-lucide="calendar" class="w-5 h-5 text-white"></i>
                                </div>
                                <h4 class="font-bold text-secondary">1996</h4>
                            </div>
                            <p class="text-sm text-gray-600">Se adquirió el primer Lowloader, consolidando el liderazgo en transporte pesado.</p>
                        </div>
                    </div>
                </div>

                <!-- Tab Content - Mission -->
                <div x-show="activeTab === 'mission'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-x-4" x-transition:enter-end="opacity-100 transform translate-x-0" style="display: none;">
                    <!-- Mission & Vision Banner -->
                    <div class="mb-6 rounded-lg overflow-hidden shadow-md">
                        <img src="temp/custom/images/banner2.jpg" alt="Nuestra Misión & Visión" class="w-full h-48 object-cover">
                        <div class="bg-gradient-to-r from-primary to-secondary p-4 text-white text-center">
                            <p class="font-bold text-lg">Impulsando la Excelencia en Logística Global</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-4">
                                <div class="bg-primary text-white rounded-full p-2 mr-3">
                                    <i data-lucide="target" class="w-5 h-5"></i>
                                </div>
                                <h3 class="text-xl font-bold text-secondary">Nuestra Misión</h3>
                            </div>
                            <p class="text-gray-600">Proporcionar servicios de logística y transporte líderes en la industria que superen las expectativas del cliente mediante confiabilidad, eficiencia e innovación, manteniendo los más altos estándares de seguridad y responsabilidad ambiental.</p>
                        </div>

                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="flex items-center mb-4">
                                <div class="bg-primary text-white rounded-full p-2 mr-3">
                                    <i data-lucide="eye" class="w-5 h-5"></i>
                                </div>
                                <h3 class="text-xl font-bold text-secondary">Nuestra Visión</h3>
                            </div>
                            <p class="text-gray-600">Ser el líder global en soluciones de transporte y logística, reconocido por nuestra innovación, excelencia en el servicio y compromiso con la sostenibilidad en cada región donde operamos.</p>
                        </div>
                    </div>

                    <div class="bg-gray-50 rounded-lg p-6 mt-6">
                        <h3 class="text-xl font-bold text-secondary mb-4">Objetivos Estratégicos</h3>
                        <ul class="space-y-3">
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-white mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Expandir nuestra presencia internacional a más de 200 países para 2028</span>
                            </li>
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-white mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Alcanzar la neutralidad de carbono en nuestras operaciones para 2030</span>
                            </li>
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-white mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Integrar tecnologías de vanguardia para mejorar el seguimiento y la eficiencia logística</span>
                            </li>
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-white mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Mantener un índice de satisfacción del cliente del 98% mediante excelencia en el servicio</span>
                            </li>
                            <li class="flex items-start">
                                <i data-lucide="check-circle" class="w-5 h-5 text-white mt-0.5 mr-2"></i>
                                <span class="text-gray-600">Desarrollar y retener la fuerza laboral más capacitada y diversa de la industria</span>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Tab Content - Values -->
                <div x-show="activeTab === 'values'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-x-4" x-transition:enter-end="opacity-100 transform translate-x-0" style="display: none;">
                    <!-- Values Header Image -->
                    <div class="mb-6 rounded-lg overflow-hidden shadow-md">
                        <img src="temp/custom/images/banner3.jpg" alt="Nuestros Valores Fundamentales" class="w-full h-40 object-cover">
                        <div class="bg-secondary p-3 text-white text-center">
                            <p class="font-medium">Nuestros Valores Fundamentales Guían Cada Decisión</p>
                        </div>
                    </div>

                    <p class="text-gray-600 mb-6">Nuestros valores fundamentales guían cada decisión que tomamos y cada acción que realizamos mientras trabajamos para cumplir nuestra misión y alcanzar nuestra visión.</p>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="shield" class="w-6 h-6 text-white"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Seguridad Primero</h4>
                            <p class="text-gray-600 text-sm">Priorizamos la seguridad de nuestro equipo, clientes y comunidades en todo lo que hacemos.</p>
                        </div>

                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="heart-handshake" class="w-6 h-6 text-white"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Enfoque en el Cliente</h4>
                            <p class="text-gray-600 text-sm">Nos comprometemos a entender y superar las expectativas de nuestros clientes.</p>
                        </div>

                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="users" class="w-6 h-6 text-white"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Trabajo en Equipo</h4>
                            <p class="text-gray-600 text-sm">Colaboramos eficazmente a través de funciones, geografías y culturas.</p>
                        </div>

                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="lightbulb" class="w-6 h-6 text-white"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Innovación</h4>
                            <p class="text-gray-600 text-sm">Buscamos continuamente nuevas ideas y tecnologías para mejorar nuestros servicios.</p>
                        </div>

                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="globe" class="w-6 h-6 text-white"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Sostenibilidad</h4>
                            <p class="text-gray-600 text-sm">Operamos de manera responsable para minimizar nuestro impacto ambiental.</p>
                        </div>

                        <div class="bg-white border border-gray-100 rounded-lg p-6 shadow-sm hover:shadow-md transition-all duration-300">
                            <div class="bg-primary bg-opacity-10 rounded-full p-3 inline-flex mb-4">
                                <i data-lucide="check-circle-2" class="w-6 h-6 text-white"></i>
                            </div>
                            <h4 class="font-bold text-secondary mb-2">Integridad</h4>
                            <p class="text-gray-600 text-sm">Mantenemos los más altos estándares éticos en todas nuestras prácticas comerciales.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Sidebar -->
            <div class="w-full md:w-1/3">
                <!-- Company Images -->
                <div class="mb-6">
                    <img src="temp/custom/images/image1.jpg" alt="Operaciones de la Empresa" class="rounded-lg shadow-md w-full mb-4">
                    <div class="bg-gray-100 p-3 text-center text-sm text-gray-600 mt-2 rounded">
                        <p>Miembro de la Asociación de Transporte por Carretera</p>
                    </div>
                </div>

                <!-- Professional Transportation Image -->
                <div class="mb-6">
                    <img src="temp/custom/images/news-image4.jpg" alt="Operaciones en Puerto de Contenedores" class="rounded-lg shadow-md w-full">
                    <div class="bg-primary/10 p-3 text-center text-sm text-secondary mt-2 rounded">
                        <p class="font-medium">Manipulación de Contenedores de Última Generación</p>
                    </div>
                </div>

                <!-- PDF Download -->
                <div class="bg-gray-50 rounded-lg p-6 flex items-center mb-6 hover:bg-gray-100 transition-all">
                    <div class="bg-primary text-white rounded-full p-3 mr-4">
                        <i data-lucide="file-text" class="w-6 h-6"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-secondary mb-1">Folleto de la Empresa</h4>
                        <a href="#" class="text-primary hover:text-secondary flex items-center">
                            <span>Descargar PDF</span>
                            <i data-lucide="download" class="w-4 h-4 ml-1"></i>
                        </a>
                    </div>
                </div>

                <!-- Quick Contact -->
                <div class="bg-secondary rounded-lg p-6 text-white">
                    <h3 class="font-bold text-xl mb-4">¿Necesitas Ayuda?</h3>
                    <ul class="space-y-3">
                        <li class="flex items-start">
                            <i data-lucide="phone" class="w-5 h-5 mr-3 mt-0.5"></i>
                            <div>
                                <p class="text-sm opacity-75">Llámanos al</p>
                                <p class="font-medium">{{ $settings->whatsapp }}</p>
                            </div>
                        </li>
                       <li class="flex items-start">
    <i data-lucide="map-pin" class="w-5 h-5 mr-3 mt-0.5"></i>
    <div>
        <p class="text-sm opacity-75">Nuestra ubicación</p>
        <p class="font-medium">{{ $settings->locations }}</p>
    </div>
</li>
</ul>
<div class="mt-4">
    <a href="contact" class="bg-primary text-white py-2 px-4 rounded flex items-center justify-center">
        <i data-lucide="message-square" class="w-4 h-4 mr-2"></i>
        Contáctanos
    </a>
</div>
</div>


                <!-- Additional Transportation Images -->

            </div>
        </div>
    </div>
</section>

<!-- Sección de Nuestros Servicios -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <!-- Título de la sección -->
        <div class="flex items-center mb-8">
            <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">02</div>
            <h2 class="text-3xl font-bold text-secondary">NUESTROS PROFESIONALES</h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Servicio 1 - Envío Aéreo -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-all duration-300 group">
                <div class="h-32 bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M17.8 19.2 16 11l3.5-3.5C21 6 21.5 4 21 3c-1-.5-3 0-4.5 1.5L13 8 4.8 6.2c-.5-.1-.9.1-1.1.5l-.3.5c-.2.5-.1 1 .3 1.3L9 12l-2 3H4l-1 1 3 2 2 3 1-1v-3l3-2 3.5 5.3c.3.4.8.5 1.3.3l.5-.2c.4-.3.6-.7.5-1.2z"></path>
                    </svg>
                </div>
                <div class="p-6">
                    <h3 class="text-lg font-bold text-secondary mb-2">ENVÍO AÉREO</h3>
                    <p class="text-gray-600 text-sm">También podemos ofrecer instalaciones de almacenamiento externas en Aberdeen y almacenamiento tanto externo como interno en {{$settings->site_name}}.</p>
                    <a href="services" class="mt-4 text-white hover:text-secondary flex items-center text-sm font-medium">
                        Más Información
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1">
                            <path d="m9 18 6-6-6-6"></path>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Servicio 2 - Logística Terrestre -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-all duration-300 group">
                <div class="h-32 bg-cover bg-center relative" style="background-image: url('temp/custom/images/delivery-trucks.jpg')">
                    <div class="absolute inset-0 bg-primary/80 flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"></path>
                            <circle cx="7" cy="17" r="2"></circle>
                            <path d="M9 17h6"></path>
                            <circle cx="17" cy="17" r="2"></circle>
                        </svg>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="text-lg font-bold text-secondary mb-2">LOGÍSTICA TERRESTRE</h3>
                    <p class="text-gray-600 text-sm">También podemos ofrecer instalaciones de almacenamiento externas en Aberdeen y almacenamiento tanto externo como interno en Cowdenbeath.</p>
                    <a href="services" class="mt-4 text-white hover:text-secondary flex items-center text-sm font-medium">
                        Más Información
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1">
                            <path d="m9 18 6-6-6-6"></path>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Servicio 3 - Transporte Marítimo -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-all duration-300 group">
                <div class="h-32 bg-cover bg-center relative" style="background-image: url('temp/custom/images/news-image4.jpg')">
                    <div class="absolute inset-0 bg-secondary/80 flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M2 21c.6.5 1.2 1 2.5 1 2.5 0 2.5-2 5-2 1.3 0 1.9.5 2.5 1 .6.5 1.2 1 2.5 1 2.5 0 2.5-2 5-2 1.3 0 1.9.5 2.5 1"></path>
                            <path d="M19.38 20A11.6 11.6 0 0 0 21 14l-9-4-9 4c0 2.9.94 5.34 2.81 7.76"></path>
                            <path d="M19 13V7a2 2 0 0 0-2-2H7a2 2 0 0 0-2 2v6"></path>
                            <path d="M12 10v4"></path>
                            <path d="M12 2v3"></path>
                        </svg>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="text-lg font-bold text-secondary mb-2">TRANSPORTE MARÍTIMO</h3>
                    <p class="text-gray-600 text-sm">También podemos ofrecer instalaciones de almacenamiento externas en Aberdeen y almacenamiento tanto externo como interno en Cowdenbeath.</p>
                    <a href="services" class="mt-4 text-white hover:text-secondary flex items-center text-sm font-medium">
                        Más Información
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1">
                            <path d="m9 18 6-6-6-6"></path>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Servicio 4 - Carga Nacional -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-all duration-300 group">
                <div class="h-32 bg-cover bg-center relative" style="background-image: url('temp/custom/images/side-image.jpg')">
                    <div class="absolute inset-0 bg-primary/80 flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="m16.5 9.4-9-5.19M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
                            <path d="M3.29 7 12 12l8.71-5M12 22V12"></path>
                        </svg>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="text-lg font-bold text-secondary mb-2">CARGA NACIONAL</h3>
                    <p class="text-gray-600 text-sm">También podemos ofrecer instalaciones de almacenamiento externas en Aberdeen y almacenamiento tanto externo como interno en Cowdenbeath.</p>
                    <a href="services" class="mt-4 text-white hover:text-secondary flex items-center text-sm font-medium">
                        Más Información
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1">
                            <path d="m9 18 6-6-6-6"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- Sección de Miembros del Equipo -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <!-- Título de la Sección -->
        <div class="flex items-center mb-6">
            <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">03</div>
            <h2 class="text-3xl font-bold text-secondary">MIEMBROS DEL CONSEJO</h2>
        </div>

        <p class="text-gray-600 max-w-3xl mb-12">Se abrió una oficina en Uithoorn, Países Bajos, para atender a un mercado europeo en crecimiento y en 2005 se inauguró una base en Great Yarmouth para atender a la ocupada industria petrolera de ida y vuelta desde Aberdeen.</p>

        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6" x-data="{ activeIndex: null }" x-cloak>
            <!-- Miembro del Equipo 1 -->
            <div
                class="bg-white rounded-lg overflow-hidden shadow-md group"
                x-on:mouseenter="activeIndex = 0"
                x-on:mouseleave="activeIndex = null"
            >
                <div class="relative">
                    <img src="temp/custom/images/member1.jpg" alt="John Harris" class="w-full h-64 object-cover">
                    <div
                        class="absolute inset-0 bg-primary bg-opacity-80 flex flex-col justify-center items-center text-white p-4 transition-all duration-300"
                        :class="{'opacity-0': activeIndex !== 0, 'opacity-100': activeIndex === 0}"
                    >
                        <h4 class="font-bold text-xl mb-2">John Harris</h4>
                        <p class="mb-4 text-center">Más de 15 años de experiencia en logística internacional y gestión de la cadena de suministro.</p>
                        <div class="flex space-x-3">
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="linkedin" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="mail" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="phone" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <h4 class="font-bold text-secondary">John Harris</h4>
                    <p class="text-sm text-gray-500">Analista de Negocios</p>
                </div>
            </div>

            <!-- Miembro del Equipo 2 -->
            <div
                class="bg-white rounded-lg overflow-hidden shadow-md group"
                x-on:mouseenter="activeIndex = 1"
                x-on:mouseleave="activeIndex = null"
            >
                <div class="relative">
                    <img src="temp/custom/images/member2.jpg" alt="Louise O'Donnell" class="w-full h-64 object-cover">
                    <div
                        class="absolute inset-0 bg-primary bg-opacity-80 flex flex-col justify-center items-center text-white p-4 transition-all duration-300"
                        :class="{'opacity-0': activeIndex !== 1, 'opacity-100': activeIndex === 1}"
                    >
                        <h4 class="font-bold text-xl mb-2">Louise O'Donnell</h4>
                        <p class="mb-4 text-center">Experta en marketing con enfoque en estrategia digital y desarrollo de marca para empresas de logística.</p>
                        <div class="flex space-x-3">
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="linkedin" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="mail" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="phone" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <h4 class="font-bold text-secondary">Louise O'Donnell</h4>
                    <p class="text-sm text-gray-500">Gerente de Marketing</p>
                </div>
            </div>

            <!-- Miembro del Equipo 3 -->
            <div
                class="bg-white rounded-lg overflow-hidden shadow-md group"
                x-on:mouseenter="activeIndex = 2"
                x-on:mouseleave="activeIndex = null"
            >
                <div class="relative">
                    <img src="temp/custom/images/member3.jpg" alt="Bernard Crotty" class="w-full h-64 object-cover">
                    <div
                        class="absolute inset-0 bg-primary bg-opacity-80 flex flex-col justify-center items-center text-white p-4 transition-all duration-300"
                        :class="{'opacity-0': activeIndex !== 2, 'opacity-100': activeIndex === 2}"
                    >
                        <h4 class="font-bold text-xl mb-2">Bernard Crotty</h4>
                        <p class="mb-4 text-center">Liderazgo experimentado en operaciones logísticas globales y desarrollo estratégico de negocios.</p>
                        <div class="flex space-x-3">
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="linkedin" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="mail" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="phone" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <h4 class="font-bold text-secondary">Bernard Crotty</h4>
                    <p class="text-sm text-gray-500">Socio Senior</p>
                </div>
            </div>

            <!-- Miembro del Equipo 4 -->
            <div
                class="bg-white rounded-lg overflow-hidden shadow-md group"
                x-on:mouseenter="activeIndex = 3"
                x-on:mouseleave="activeIndex = null"
            >
                <div class="relative">
                    <img src="temp/custom/images/member4.jpg" alt="Melanie Saunders" class="w-full h-64 object-cover">
                    <div
                        class="absolute inset-0 bg-primary bg-opacity-80 flex flex-col justify-center items-center text-white p-4 transition-all duration-300"
                        :class="{'opacity-0': activeIndex !== 3, 'opacity-100': activeIndex === 3}"
                    >
                        <h4 class="font-bold text-xl mb-2">Melanie Saunders</h4>
                        <p class="mb-4 text-center">Experta financiera especializada en contabilidad de logística y transporte internacional.</p>
                        <div class="flex space-x-3">
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="linkedin" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="mail" class="w-4 h-4"></i>
                            </a>
                            <a href="#" class="bg-white text-primary p-2 rounded-full hover:bg-gray-100 transition-all">
                                <i data-lucide="phone" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <h4 class="font-bold text-secondary">Melanie Saunders</h4>
                    <p class="text-sm text-gray-500">Contabilidad</p>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- Nuestros Socios -->
<section class="py-12 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-8">
            <h2 class="text-2xl font-bold text-secondary">Nuestros Socios de Confianza</h2>
            <p class="text-gray-600 mt-2">Empresas que confían en nuestros servicios en todo el mundo</p>
        </div>

        <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-6 gap-4 items-center">
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo1.jpg" alt="Socio" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo2.jpg" alt="Socio" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo3.jpg" alt="Socio" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo4.jpg" alt="Socio" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo5.jpg" alt="Socio" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo6.jpg" alt="Socio" class="max-h-12 filter grayscale hover:grayscale-0 transition-all duration-300">
            </div>
        </div>
    </div>
</section>


<!-- Sección de Llamado a la Acción -->
<section class="py-12 bg-secondary relative">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="mb-6 md:mb-0">
                <h2 class="text-2xl md:text-3xl font-bold text-white">¿Listo para Enviar Tu Paquete?</h2>
                <p class="text-white text-opacity-90 mt-2">¡Contáctanos hoy para obtener una cotización de envío gratuita!</p>
            </div>
            <div class="flex flex-wrap gap-4">
                <a href="contact" class="bg-white text-primary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i data-lucide="phone" class="w-5 h-5 mr-2"></i>
                    Contáctanos
                </a>
                <a href="request-quote" class="bg-primary text-white hover:bg-primary-dark py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i data-lucide="clipboard-check" class="w-5 h-5 mr-2"></i>
                    Obtener Cotización
                </a>
            </div>
        </div>
    </div>

    <!-- Patrón de Onda Inferior -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 48" class="text-white fill-current">
            <path d="M0,0L48,8C96,16,192,32,288,32C384,32,480,16,576,16C672,16,768,32,864,37.3C960,43,1056,37,1152,32C1248,27,1344,21,1392,18.7L1440,16L1440,48L1392,48C1344,48,1248,48,1152,48C1056,48,960,48,864,48C768,48,672,48,576,48C480,48,384,48,288,48C192,48,96,48,48,48L0,48Z"></path>
        </svg>
    </div>
</section>


@push('scripts')
<script>
    // Ensure Lucide icons are initialized properly
    document.addEventListener('DOMContentLoaded', function() {
        if (typeof lucide !== 'undefined') {
            lucide.createIcons();
        } else {
            console.error('Lucide library not loaded');

            // Attempt to load Lucide if not available
            const script = document.createElement('script');
            script.src = 'https://unpkg.com/lucide@latest/dist/umd/lucide.js';
            script.onload = function() {
                lucide.createIcons();
                console.log('Lucide loaded and icons created');
            };
            document.head.appendChild(script);
        }
    });
</script>
@endpush

@push('scripts')
<script>
document.addEventListener('alpine:init', () => {
  document.addEventListener('alpine:initialized', () => lucide.createIcons());
  document.addEventListener('alpine:updated', () => lucide.createIcons());
});
</script>

<!-- Lucide Icons -->
<script src="https://unpkg.com/lucide@latest"></script>
<script>
  lucide.createIcons();
</script>

<script>
    // Ensure all SVG icons display correctly
    document.addEventListener('DOMContentLoaded', function() {
        // If Lucide is available, initialize it
        if (typeof lucide !== 'undefined') {
            lucide.createIcons();

            // Re-initialize icons after Alpine.js updates
            document.addEventListener('alpine:initialized', function() {
                setTimeout(function() {
                    lucide.createIcons();
                }, 100);
            });

            // Set up an interval to check if icons need to be reinitialized
            setInterval(function() {
                lucide.createIcons();
            }, 2000);
        }
    });
</script>
@endpush

@endsection
