<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Shipment Status Update</title>
    <style>
        /* Reset styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333333;
            background-color: #f4f6f8;
        }

        .email-container {
            max-width: 650px;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }

        /* Header */
        .email-header {
            background: linear-gradient(135deg, #0A1F44 0%, #1F6FEB 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }

        .update-icon {
            font-size: 48px;
            margin-bottom: 15px;
        }

        .email-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .email-subtitle {
            font-size: 16px;
            opacity: 0.9;
        }

        /* Status Update Alert */
        .status-alert {
            background: linear-gradient(135deg, #FF4D00 0%, #FF6B2B 100%);
            color: white;
            padding: 20px;
            text-align: center;
            margin: 0;
        }

        .status-alert-text {
            font-size: 18px;
            font-weight: bold;
        }

        /* Main content */
        .email-body {
            padding: 40px 30px;
        }

        .greeting {
            font-size: 18px;
            margin-bottom: 20px;
            color: #0A1F44;
        }

        .intro-text {
            font-size: 15px;
            line-height: 1.6;
            margin-bottom: 30px;
            color: #666;
        }

        /* Current Status Section */
        .current-status {
            background: #f8f9fa;
            border: 2px solid #FF4D00;
            border-radius: 10px;
            padding: 25px;
            text-align: center;
            margin: 25px 0;
        }

        .status-label {
            font-size: 14px;
            text-transform: uppercase;
            color: #666;
            margin-bottom: 10px;
        }

        .status-value {
            font-size: 24px;
            font-weight: bold;
            color: #FF4D00;
            margin-bottom: 15px;
        }

        .location-info {
            background-color: white;
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
        }

        .location-label {
            font-size: 12px;
            text-transform: uppercase;
            color: #888;
            margin-bottom: 5px;
        }

        .location-value {
            font-size: 16px;
            font-weight: 600;
            color: #333;
        }

        /* Progress Bar */
        .progress-section {
            margin: 30px 0;
        }

        .progress-label {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }

        .progress-bar {
            width: 100%;
            height: 8px;
            background-color: #e9ecef;
            border-radius: 4px;
            overflow: hidden;
        }

        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #28A745 0%, #20C997 100%);
            transition: width 0.3s ease;
        }

        .progress-text {
            text-align: center;
            margin-top: 10px;
            font-weight: bold;
            color: #28A745;
        }

        /* Status Message */
        .status-message {
            background-color: #e3f2fd;
            border-left: 4px solid #2196F3;
            padding: 20px;
            margin: 25px 0;
            border-radius: 0 8px 8px 0;
        }

        .status-icon {
            font-size: 20px;
            margin-right: 10px;
        }

        /* Tracking section */
        .tracking-section {
            background: linear-gradient(135deg, #0A1F44 0%, #1F6FEB 100%);
            color: white;
            padding: 25px;
            border-radius: 10px;
            text-align: center;
            margin: 30px 0;
        }

        .tracking-label {
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
            opacity: 0.9;
        }

        .tracking-number {
            font-size: 28px;
            font-weight: bold;
            letter-spacing: 2px;
            margin-bottom: 15px;
        }

        .tracking-btn {
            display: inline-block;
            background-color: white;
            color: #0A1F44;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin-top: 10px;
            transition: all 0.3s ease;
        }

        .tracking-btn:hover {
            background-color: #f8f9fa;
            transform: translateY(-2px);
        }

        /* Details section */
        .details-section {
            background-color: #f8f9fa;
            border-left: 4px solid #28A745;
            padding: 25px;
            margin: 30px 0;
            border-radius: 0 8px 8px 0;
        }

        .details-title {
            font-size: 18px;
            font-weight: bold;
            color: #0A1F44;
            margin-bottom: 20px;
        }

        .details-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
        }

        .detail-item {
            display: flex;
            flex-direction: column;
        }

        .detail-label {
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #888;
            margin-bottom: 5px;
        }

        .detail-value {
            font-size: 14px;
            font-weight: 600;
            color: #333;
        }

        /* Contact section */
        .contact-section {
            background-color: #0A1F44;
            color: white;
            padding: 25px;
            margin: 30px 0;
            border-radius: 8px;
        }

        .contact-title {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 15px;
        }

        .contact-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
        }

        .contact-item {
            font-size: 14px;
            line-height: 1.4;
        }

        /* Footer */
        .email-footer {
            background-color: #f8f9fa;
            padding: 30px;
            text-align: center;
            border-top: 1px solid #e9ecef;
        }

        .company-info {
            margin-bottom: 20px;
        }

        .company-name {
            font-size: 18px;
            font-weight: bold;
            color: #0A1F44;
            margin-bottom: 5px;
        }

        .company-details {
            font-size: 14px;
            color: #666;
            line-height: 1.4;
        }

        .footer-links {
            margin: 20px 0;
        }

        .footer-link {
            color: #FF4D00;
            text-decoration: none;
            margin: 0 15px;
            font-size: 14px;
        }

        .disclaimer {
            font-size: 12px;
            color: #888;
            line-height: 1.4;
            margin-top: 20px;
        }

        /* Status-specific colors */
        .status-delivered { background-color: #d4edda; border-color: #28a745; }
        .status-in-transit { background-color: #cce5ff; border-color: #007bff; }
        .status-on-hold { background-color: #fff3cd; border-color: #ffc107; }
        .status-customs { background-color: #e2e3e5; border-color: #6c757d; }

        /* Responsive */
        @media (max-width: 600px) {
            .email-container {
                margin: 0;
                box-shadow: none;
            }

            .email-header, .email-body, .email-footer {
                padding: 20px;
            }

            .details-grid, .contact-grid {
                grid-template-columns: 1fr;
            }

            .tracking-number {
                font-size: 22px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="email-header">
            <div class="update-icon">📦</div>
            <h1 class="email-title">Shipment Status Update</h1>
            <p class="email-subtitle">Your Package is Moving</p>
        </div>

        <!-- Status Alert -->
        <div class="status-alert">
            <div class="status-alert-text">🚚 Your shipment status has been updated!</div>
        </div>

        <!-- Main Body -->
        <div class="email-body">
            <div class="greeting">
                @if($emailType === 'sender')
                    Dear {{ $shipmentData['sname'] }},
                @else
                    Dear {{ $shipmentData['name'] }},
                @endif
            </div>

            <div class="intro-text">
                @if($emailType === 'sender')
                    We are writing to inform you about an important update regarding your shipment with <strong>{{ $settings->site_name }}</strong>. The status of your package has been updated in our system.
                @else
                    We wanted to keep you informed about your incoming shipment. There has been an update to the status of your package being handled by <strong>{{ $settings->site_name }}</strong>.
                @endif
            </div>

            <!-- Current Status -->
            <div class="current-status">
                <div class="status-label">Current Status</div>
                <div class="status-value">{{ $shipmentData['status'] }}</div>
                <div class="location-info">
                    <div class="location-label">Current Location</div>
                    <div class="location-value">📍 {{ $shipmentData['location'] }}</div>
                    <div style="margin-top: 10px;">
                        <div class="location-label">Address</div>
                        <div style="font-size: 14px; color: #666;">{{ $shipmentData['addresslocation'] }}</div>
                    </div>
                </div>
            </div>

            @if($shipmentData['percentage_complete'])
            <!-- Progress Bar -->
            <div class="progress-section">
                <div class="progress-label">Delivery Progress</div>
                <div class="progress-bar">
                    <div class="progress-fill" style="width: {{ $shipmentData['percentage_complete'] }}%"></div>
                </div>
                <div class="progress-text">{{ $shipmentData['percentage_complete'] }}% Complete</div>
            </div>
            @endif

            <!-- Status Message -->
            <div class="status-message">
                @if($shipmentData['status'] === 'In Transit')
                    <span class="status-icon">✅</span><strong>Good News!</strong> Your shipment is currently on its way to the destination.
                @elseif($shipmentData['status'] === 'Delivered')
                    <span class="status-icon">🎉</span><strong>Delivered!</strong> Your shipment has been successfully delivered.
                @elseif($shipmentData['status'] === 'On Hold')
                    <span class="status-icon">⚠️</span><strong>Attention Required:</strong> Your shipment is currently on hold. Please contact our support team for more information.
                @elseif($shipmentData['status'] === 'Customs')
                    <span class="status-icon">📋</span><strong>Customs Processing:</strong> Your shipment is currently being processed by customs authorities.
                @elseif($shipmentData['status'] === 'Out for Delivery')
                    <span class="status-icon">🚚</span><strong>Out for Delivery:</strong> Your package is out for delivery and should arrive soon!
                @else
                    <span class="status-icon">📦</span><strong>Status Update:</strong> Your shipment status has been updated to "{{ $shipmentData['status'] }}".
                @endif
            </div>

            <!-- Tracking Section -->
            <div class="tracking-section">
                <div class="tracking-label">Track with Number</div>
                <div class="tracking-number">{{ $shipmentData['trackingnumber'] }}</div>
                <a href="{{ $settings->site_address }}/track-order" class="tracking-btn">Track Shipment</a>
            </div>

            <!-- Shipment Details -->
            <div class="details-section">
                <div class="details-title">📦 Updated Shipment Information</div>
                <div class="details-grid">
                    <div class="detail-item">
                        <div class="detail-label">From</div>
                        <div class="detail-value">{{ $shipmentData['take_off_point'] ?? $shipmentData['saddress'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">To</div>
                        <div class="detail-value">{{ $shipmentData['final_destination'] ?? $shipmentData['address'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Service Type</div>
                        <div class="detail-value">{{ $shipmentData['freight_type'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Content Type</div>
                        <div class="detail-value">{{ $shipmentData['shipment_type'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Weight</div>
                        <div class="detail-value">{{ $shipmentData['weight'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Date Shipped</div>
                        <div class="detail-value">{{ \Carbon\Carbon::parse($shipmentData['date_shipped'])->format('M d, Y \a\t h:i A') }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Expected Delivery</div>
                        <div class="detail-value">{{ \Carbon\Carbon::parse($shipmentData['expected_delivery'])->format('M d, Y \a\t h:i A') }}</div>
                    </div>
                    @if($shipmentData['cost'])
                    <div class="detail-item">
                        <div class="detail-label">Shipping Cost</div>
                        <div class="detail-value">${{ $shipmentData['cost'] }}</div>
                    </div>
                    @endif
                </div>
            </div>

            @if($shipmentData['description'])
            <div style="margin: 20px 0; padding: 15px; background-color: #f8f9fa; border-radius: 5px;">
                <strong>Shipment Description:</strong> {{ $shipmentData['description'] }}
            </div>
            @endif

            <!-- Contact Information -->
            <div class="contact-section">
                <div class="contact-title">📞 Contact Information</div>
                <div class="contact-grid">
                    @if($emailType === 'sender')
                        <div class="contact-item">
                            <strong>Recipient Details:</strong><br>
                            Name: {{ $shipmentData['name'] }}<br>
                            Email: {{ $shipmentData['email'] }}<br>
                            Phone: {{ $shipmentData['phone'] }}<br>
                            Address: {{ $shipmentData['address'] }}, {{ $shipmentData['country'] }}
                        </div>
                    @else
                        <div class="contact-item">
                            <strong>Sender Details:</strong><br>
                            Name: {{ $shipmentData['sname'] }}<br>
                            Email: {{ $shipmentData['semail'] }}<br>
                            Phone: {{ $shipmentData['sphone'] }}<br>
                            Address: {{ $shipmentData['saddress'] }}, {{ $shipmentData['scountry'] }}
                        </div>
                    @endif
                    <div class="contact-item">
                        <strong>Customer Support:</strong><br>
                        Email: {{ $settings->contact_email }}<br>
                        @if($settings->whatsapp)
                        Phone: {{ $settings->whatsapp }}<br>
                        @endif
                        Website: {{ $settings->site_address }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="email-footer">
            <div class="company-info">
                <div class="company-name">{{ $settings->site_name }}</div>
                <div class="company-details">
                    Professional Courier & Logistics Services<br>
                    {{ $settings->locations }}<br>
                    {{ $settings->contact_email }}
                </div>
            </div>

            <div class="footer-links">
                <a href="{{ $settings->site_address }}/track-order" class="footer-link">Track Shipment</a>
                <a href="{{ $settings->site_address }}/contact" class="footer-link">Contact Us</a>
                <a href="{{ $settings->site_address }}/services" class="footer-link">Our Services</a>
            </div>

            <div class="disclaimer">
                <strong>Important Information:</strong><br>
                • This is an automated update based on the latest scan of your package<br>
                • If you have any questions about this update, please contact our support team<br>
                • Delivery times may vary based on location and weather conditions<br>
                • For urgent matters, please contact us immediately using the information above<br><br>

                This is an automated update notification. Please do not reply directly to this email.<br>
                For assistance, please contact {{ $settings->contact_email }}<br><br>

                © {{ date('Y') }} {{ $settings->site_name }}. All rights reserved.
            </div>
        </div>
    </div>
</body>
</html>
