<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $emailType === 'sender' ? 'Shipment Pickup Confirmation' : 'Shipment Notification' }}</title>
    <style>
        /* Reset styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333333;
            background-color: #f4f6f8;
        }

        .email-container {
            max-width: 650px;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }

        /* Header */
        .email-header {
            background: linear-gradient(135deg, #0A1F44 0%, #1F6FEB 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }

        .logo {
            max-height: 50px;
            margin-bottom: 15px;
        }

        .email-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .email-subtitle {
            font-size: 16px;
            opacity: 0.9;
        }

        /* Main content */
        .email-body {
            padding: 40px 30px;
        }

        .greeting {
            font-size: 18px;
            margin-bottom: 20px;
            color: #0A1F44;
        }

        .intro-text {
            font-size: 15px;
            line-height: 1.6;
            margin-bottom: 30px;
            color: #666;
        }

        /* Tracking section */
        .tracking-section {
            background: linear-gradient(135deg, #FF4D00 0%, #FF6B2B 100%);
            color: white;
            padding: 25px;
            border-radius: 10px;
            text-align: center;
            margin: 30px 0;
        }

        .tracking-label {
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
            opacity: 0.9;
        }

        .tracking-number {
            font-size: 28px;
            font-weight: bold;
            letter-spacing: 2px;
            margin-bottom: 15px;
        }

        .tracking-btn {
            display: inline-block;
            background-color: white;
            color: #FF4D00;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin-top: 10px;
            transition: all 0.3s ease;
        }

        .tracking-btn:hover {
            background-color: #f8f9fa;
            transform: translateY(-2px);
        }

        /* Details section */
        .details-section {
            background-color: #f8f9fa;
            border-left: 4px solid #FF4D00;
            padding: 25px;
            margin: 30px 0;
            border-radius: 0 8px 8px 0;
        }

        .details-title {
            font-size: 18px;
            font-weight: bold;
            color: #0A1F44;
            margin-bottom: 20px;
        }

        .details-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
        }

        .detail-item {
            display: flex;
            flex-direction: column;
        }

        .detail-label {
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #888;
            margin-bottom: 5px;
        }

        .detail-value {
            font-size: 14px;
            font-weight: 600;
            color: #333;
        }

        /* Status badge */
        .status-badge {
            display: inline-block;
            background-color: #28A745;
            color: white;
            padding: 5px 12px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
        }

        /* Contact section */
        .contact-section {
            background-color: #0A1F44;
            color: white;
            padding: 25px;
            margin: 30px 0;
            border-radius: 8px;
        }

        .contact-title {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 15px;
        }

        .contact-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
        }

        .contact-item {
            font-size: 14px;
            line-height: 1.4;
        }

        /* Footer */
        .email-footer {
            background-color: #f8f9fa;
            padding: 30px;
            text-align: center;
            border-top: 1px solid #e9ecef;
        }

        .company-info {
            margin-bottom: 20px;
        }

        .company-name {
            font-size: 18px;
            font-weight: bold;
            color: #0A1F44;
            margin-bottom: 5px;
        }

        .company-details {
            font-size: 14px;
            color: #666;
            line-height: 1.4;
        }

        .footer-links {
            margin: 20px 0;
        }

        .footer-link {
            color: #FF4D00;
            text-decoration: none;
            margin: 0 15px;
            font-size: 14px;
        }

        .disclaimer {
            font-size: 12px;
            color: #888;
            line-height: 1.4;
            margin-top: 20px;
        }

        /* Responsive */
        @media (max-width: 600px) {
            .email-container {
                margin: 0;
                box-shadow: none;
            }

            .email-header, .email-body, .email-footer {
                padding: 20px;
            }

            .details-grid, .contact-grid {
                grid-template-columns: 1fr;
            }

            .tracking-number {
                font-size: 22px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="email-header">
            <h1 class="email-title">{{ $emailType === 'sender' ? 'Shipment Pickup Confirmation' : 'Shipment Notification' }}</h1>
            <p class="email-subtitle">Professional Courier & Logistics Services</p>
        </div>

        <!-- Main Body -->
        <div class="email-body">
            <div class="greeting">
                @if($emailType === 'sender')
                    Dear {{ $shipmentData['sname'] }},
                @else
                    Dear {{ $shipmentData['name'] }},
                @endif
            </div>

            <div class="intro-text">
                @if($emailType === 'sender')
                    Thank you for choosing <strong>{{ $settings->site_name }}</strong> for your shipping needs. We are pleased to confirm that your shipment has been successfully processed and is now in our logistics network.
                @else
                    We are writing to inform you that a shipment addressed to you has been processed through <strong>{{ $settings->site_name }}</strong> and is currently being prepared for delivery.
                @endif
            </div>

            <!-- Tracking Section -->
            <div class="tracking-section">
                <div class="tracking-label">Your Tracking Number</div>
                <div class="tracking-number">{{ $shipmentData['trackingnumber'] }}</div>
                <a href="{{ $settings->site_address }}/track-order" class="tracking-btn">Track Shipment</a>
            </div>

            <!-- Shipment Details -->
            <div class="details-section">
                <div class="details-title">📦 Shipment Details</div>
                <div class="details-grid">
                    <div class="detail-item">
                        <div class="detail-label">From</div>
                        <div class="detail-value">{{ $shipmentData['take_off_point'] ?? $shipmentData['saddress'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">To</div>
                        <div class="detail-value">{{ $shipmentData['final_destination'] ?? $shipmentData['address'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Service Type</div>
                        <div class="detail-value">{{ $shipmentData['freight_type'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Content Type</div>
                        <div class="detail-value">{{ $shipmentData['shipment_type'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Weight</div>
                        <div class="detail-value">{{ $shipmentData['weight'] }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Status</div>
                        <div class="detail-value"><span class="status-badge">{{ $shipmentData['status'] }}</span></div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Date Shipped</div>
                        <div class="detail-value">{{ \Carbon\Carbon::parse($shipmentData['date_shipped'])->format('M d, Y \a\t h:i A') }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Expected Delivery</div>
                        <div class="detail-value">{{ \Carbon\Carbon::parse($shipmentData['expected_delivery'])->format('M d, Y \a\t h:i A') }}</div>
                    </div>
                </div>
            </div>

            @if($shipmentData['description'])
            <div style="margin: 20px 0;">
                <strong>Shipment Description:</strong> {{ $shipmentData['description'] }}
            </div>
            @endif

            <!-- Contact Information -->
            <div class="contact-section">
                <div class="contact-title"> Contact Information</div>
                <div class="contact-grid">
                    @if($emailType === 'sender')
                        <div>
                            <strong>Recipient Details:</strong><br>
                            Name: {{ $shipmentData['name'] }}<br>
                            Email: {{ $shipmentData['email'] }}<br>
                            Phone: {{ $shipmentData['phone'] }}<br>
                            Address: {{ $shipmentData['address'] }}, {{ $shipmentData['country'] }}
                        </div>
                    @else
                        <div>
                            <strong>Sender Details:</strong><br>
                            Name: {{ $shipmentData['sname'] }}<br>
                            Email: {{ $shipmentData['semail'] }}<br>
                            Phone: {{ $shipmentData['sphone'] }}<br>
                            Address: {{ $shipmentData['saddress'] }}, {{ $shipmentData['scountry'] }}
                        </div>
                    @endif
                    <div>
                        <strong>Customer Support:</strong><br>
                        Email: {{ $settings->contact_email }}<br>
                        @if($settings->whatsapp)
                        Phone: {{ $settings->whatsapp }}<br>
                        @endif
                        Website: {{ $settings->site_address }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="email-footer">
            <div class="company-info">
                <div class="company-name">{{ $settings->site_name }}</div>
                <div class="company-details">
                    Professional Courier & Logistics Services<br>
                    {{ $settings->locations }}<br>
                    {{ $settings->contact_email }}
                </div>
            </div>

            <div class="footer-links">
                <a href="{{ $settings->site_address }}/track-order" class="footer-link">Track Shipment</a>
                <a href="{{ $settings->site_address }}/contact" class="footer-link">Contact Us</a>
                <a href="{{ $settings->site_address }}/services" class="footer-link">Our Services</a>
            </div>

            <div class="disclaimer">
                <strong>Important Notes:</strong><br>
                • Please keep your tracking number safe for future reference<br>
                • For any inquiries, please contact us at {{ $settings->contact_email }}<br>
                • Delivery times may vary based on location and weather conditions<br>
                • Ensure someone is available at the delivery address during business hours<br><br>

                This is an automated message. Please do not reply directly to this email.<br>
                For assistance, please contact {{ $settings->contact_email }}<br><br>

                © {{ date('Y') }} {{ $settings->site_name }}. All rights reserved.
            </div>
        </div>
    </div>
</body>
</html>
