@component('mail::message')
# New Quote Request Received

A new quote request has been submitted on {{ $settings->site_title }}.

**Reference Number:** {{ $quoteRequest->reference_number }}

## Customer Information
- **Name:** {{ $quoteRequest->full_name }}
- **Email:** {{ $quoteRequest->email }}
- **Phone:** {{ $quoteRequest->phone ?? 'Not provided' }}
- **Company:** {{ $quoteRequest->company_name ?? 'Not provided' }}

## Shipment Details
- **Freight Type:** {{ $quoteRequest->freight_type }}
- **From:** {{ $quoteRequest->departure_country }}
- **To:** {{ $quoteRequest->recipient_country }}
- **Weight:** {{ $quoteRequest->weight ?? 'Not specified' }} KG
- **Dimensions:** {{ $quoteRequest->dimensions ?? 'Not specified' }}
- **Priority:** {{ ucfirst($quoteRequest->priority) }}
- **Insurance:** {{ $quoteRequest->insurance ? 'Yes' : 'No' }}
- **Expected Delivery:** {{ $quoteRequest->expected_delivery_date ? $quoteRequest->expected_delivery_date->format('M d, Y') : 'Not specified' }}

@if($quoteRequest->description)
## Description
{{ $quoteRequest->description }}
@endif

@component('mail::button', ['url' => url('/admin/dashboard')])
View in Admin Panel
@endcomponent

Please review this request and provide a quote as soon as possible.

Thanks,<br>
{{ $settings->site_title }} System
@endcomponent
