@extends('layouts.base')

@section('content')
<div class="container py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Shipments</h1>
        <a href="{{ route('admin.shipments.create') }}" class="bg-primary text-white px-4 py-2 rounded">Create Shipment</a>
    </div>
    @if(session('success'))
        <div class="bg-green-100 text-green-800 p-3 rounded mb-4">{{ session('success') }}</div>
    @endif
    <div class="overflow-x-auto">
        <table class="min-w-full bg-white border">
            <thead>
                <tr>
                    <th class="px-4 py-2 border">Tracking #</th>
                    <th class="px-4 py-2 border">Sender</th>
                    <th class="px-4 py-2 border">Receiver</th>
                    <th class="px-4 py-2 border">Status</th>
                    <th class="px-4 py-2 border">Shipped</th>
                    <th class="px-4 py-2 border">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($shipments as $shipment)
                <tr>
                    <td class="border px-4 py-2">{{ $shipment->trackingnumber }}</td>
                    <td class="border px-4 py-2">{{ $shipment->sender_name }}</td>
                    <td class="border px-4 py-2">{{ $shipment->receiver_name }}</td>
                    <td class="border px-4 py-2">{{ $shipment->status }}</td>
                    <td class="border px-4 py-2">{{ $shipment->date_shipped }}</td>
                    <td class="border px-4 py-2">
                        <a href="{{ route('admin.shipments.show', $shipment->id) }}" class="text-blue-600">View</a> |
                        <a href="{{ route('admin.shipments.edit', $shipment->id) }}" class="text-yellow-600">Edit</a> |
                        <a href="{{ route('admin.shipments.updateform', $shipment->id) }}" class="text-green-600">Update Status</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="mt-4">
        {{ $shipments->links() }}
    </div>
</div>
@endsection
