<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuoteRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quote_requests', function (Blueprint $table) {
            $table->id();
            $table->string('freight_type');
            $table->string('email');
            $table->string('departure_country');
            $table->string('weight')->nullable();
            $table->string('recipient_country');
            $table->date('expected_delivery_date')->nullable();
            $table->string('full_name');
            $table->string('phone')->nullable();
            $table->string('company_name')->nullable();
            $table->text('description')->nullable();
            $table->string('dimensions')->nullable();
            $table->enum('priority', ['economy', 'standard', 'express'])->default('standard');
            $table->boolean('insurance')->default(false);
            $table->enum('status', ['pending', 'quoted', 'processed', 'cancelled'])->default('pending');
            $table->decimal('quoted_amount', 10, 2)->nullable();
            $table->text('admin_notes')->nullable();
            $table->string('reference_number')->unique();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quote_requests');
    }
}
