<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('shipments', function (Blueprint $table) {
            $table->id();
            $table->string('trackingnumber')->unique();
            $table->string('sender_name');
            $table->string('sender_address');
            $table->string('sender_email');
            $table->string('sender_phone');
            $table->string('receiver_name');
            $table->string('receiver_address');
            $table->string('receiver_email');
            $table->string('receiver_phone');
            $table->string('origin');
            $table->string('destination');
            $table->string('shipment_type');
            $table->string('freight_type');
            $table->string('weight');
            $table->date('date_shipped');
            $table->date('expected_delivery');
            $table->string('status');
            $table->text('description')->nullable();
            $table->string('photo')->nullable();
            $table->string('location')->nullable();
            $table->string('addresslocation')->nullable();
            $table->decimal('cost', 10, 2)->nullable();
            $table->decimal('clearance_cost', 10, 2)->nullable();
            $table->integer('qty')->nullable();
            $table->integer('percentage_complete')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('shipments');
    }
};
