<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class ShipmentUpdate extends Mailable
{
    use Queueable, SerializesModels;

    public $shipmentData;
    public $settings;
    public $emailType; // 'sender' or 'receiver'

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($shipmentData, $settings, $emailType = 'receiver')
    {
        $this->shipmentData = $shipmentData;
        $this->settings = $settings;
        $this->emailType = $emailType;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $subject = $this->emailType === 'sender'
            ? "Shipment Update - Tracking #{$this->shipmentData['trackingnumber']}"
            : "Shipment Status Update - Tracking #{$this->shipmentData['trackingnumber']}";

        return $this->view('emails.shipment-update-custom', [
            'shipmentData' => $this->shipmentData,
            'settings' => $this->settings,
            'emailType' => $this->emailType,
        ])
        ->subject($subject)
        ->from($this->settings->emailfrom, $this->settings->emailfromname);
    }
}
