<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class ShipmentConfirmation extends Mailable
{
    use Queueable, SerializesModels;

    public $shipmentData;
    public $settings;
    public $emailType; // 'sender' or 'receiver'

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($shipmentData, $settings, $emailType = 'receiver')
    {
        $this->shipmentData = $shipmentData;
        $this->settings = $settings;
        $this->emailType = $emailType;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $subject = $this->emailType === 'sender'
            ? "Shipment Pickup Confirmation - Tracking #{$this->shipmentData['trackingnumber']}"
            : "Shipment Notification - Tracking #{$this->shipmentData['trackingnumber']}";

        return $this->view('emails.shipment-confirmation-custom', [
            'shipmentData' => $this->shipmentData,
            'settings' => $this->settings,
            'emailType' => $this->emailType,
        ])
        ->subject($subject)
        ->from($this->settings->emailfrom, $this->settings->emailfromname);
    }
}
